/**
 * \file      dia_SrvHandler_WriteADCRefPlusActualVoltage.cpp
 *
 * \brief     {Reference + Actual/ Measured bytes => ADC Voltage write}
 *
 * \details   {Reference + Actual/ Measured bytes => ADC Voltage write}
 *
 * \author    bhs1hi
 * \date      Jul 28, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_ADC_REF_ACTUAL_VOLTAGE_WRITE__
#include "common/services/uds/production/dia_SrvHandler_WriteADCRefPlusActualVoltage.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

#define MSG_DATA_OFFSET 4 // Offset from oDiagMsgBuffer-start to 1st data-byte (e.g. MemorySize-Byte)
#define DATA_START      3

static const tU16 DIA_C_U16_ADC_VALUE_LENGTH_MAX  = 4;
static const tU16 DIA_C_U16_ADC_VALUE_LENGTH_MIN  = 4;

//-----------------------------------------------------------------------------

dia_SrvHandler_WriteADCRefPlusActualVoltage::dia_SrvHandler_WriteADCRefPlusActualVoltage ( void )
   : dia_ServiceHandlerUDS("dia_SrvHandler_WriteADCRefPlusActualVoltage",DIA_C_U8_UDS_SID_WRITE_DATA_BY_IDENTIFIER,DIA_C_U16_DID_CM_ADC_REF_PLUS_ACTUAL_VOLTAGE)
{
   dia_tclFnctTrace trc("dia_SrvHandler_WriteADCRefPlusActualVoltage::dia_SrvHandler_WriteADCRefPlusActualVoltage");
}
//-----------------------------------------------------------------------------

void
dia_SrvHandler_WriteADCRefPlusActualVoltage::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_WriteADCRefPlusActualVoltage::vOnProcessRequest");

   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();
   tU8 u8propData[DIA_PROP_LENGTH_MAX] = {0};
   tU8 u8tempPropData[DIA_PROP_LENGTH_MAX] = {0};

   // initialize the data memory
   (void) ::memset(u8propData,0,DIA_PROP_LENGTH_MAX);
   (void) ::memset(u8tempPropData,0,DIA_PROP_LENGTH_MAX);

   // copy until end of msg. (max ms length == 240B) or '\0' (0x0)
   tU16 u16EleCount = 0;
   for ( ; u16EleCount < (oDiagMsgBuffer().u16GetDataLength()-MSG_DATA_OFFSET); u16EleCount++){
      if ( u16EleCount < DIA_PROP_LENGTH_MAX ) {
         u8propData[u16EleCount] = pU8[u16EleCount+MSG_DATA_OFFSET];
         DIA_TR_INF("dia_SrvHandler_WriteADCRefPlusActualVoltage::u8propData[%d] 0x%02x", u16EleCount, u8propData[u16EleCount]);
      }
   }
   tDiaResult retCode = checkLength(u16EleCount,DIA_C_U16_ADC_VALUE_LENGTH_MIN,DIA_C_U16_ADC_VALUE_LENGTH_MAX);
   if ( retCode != DIA_SUCCESS )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandler_WriteADCRefPlusActualVoltage: FAILED (DATA VALIDATION) !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(retCode));
      return;
   }
   u8tempPropData[0] = u8propData[1];
   u8tempPropData[1] = u8propData[0];
   u8tempPropData[2] = u8propData[3];
   u8tempPropData[3] = u8propData[2];
   retCode = dia_setProperty ( DIA_PROP_AID_ADC_REF_PLUS_ACTUAL_VOLTAGE, u8tempPropData, u16EleCount );
   if ( retCode != DIA_SUCCESS )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandler_WriteADCRefPlusActualVoltage: FAILED (WRITE DATA TO PERSISTENT MEMORY) !!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      return;
   }
   // Sending back the positive answer
   DIA_TR_INF("dia_SrvHandler_WriteADCRefPlusActualVoltage: SUCCEEDED");
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START);
   vResReadyAndQuit();
}
//-----------------------------------------------------------------------------

tDiaResult
dia_SrvHandler_WriteADCRefPlusActualVoltage::checkLength ( tU16 length, tU16 minValue, tU16 maxValue )
{
   dia_tclFnctTrace trc("dia_SrvHandler_WriteADCRefPlusActualVoltage::checkLength");
   return ((length >= minValue) && (length <= maxValue)) ? DIA_SUCCESS : DIA_FAILED;
}
