/**
 * \file      dia_SrvHandler_USB_PowerSupplyInfoPort.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    kaa1hi
 * \date      Feb 10, 2015
 *
 * \copyright Robert Bosch Car Multimedia 2015
 *
 * TTFis:> DIA_REQ UDS 00 22 63 21     # USB Port 1
 * TTFis:> DIA_REQ UDS 00 22 63 22     # USB Port 2
 * TTFis:> DIA_REQ UDS 00 22 63 23     # USB Port 3
 */

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DEVICE_MANAGER_LISTENER__
#include "common/interfaces/dia_IDeviceMGRListener.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_SrvHandler_USB_PowerSupplyInfoPort.h"


#define DATA_START   3
#define DATA_LENGTH  3

#define DIA_POWERSUPPLYINFO_MAX_USB_PORT_NUMBER           ((tU8)2)

enum eReceivedStatusBitMask
{
   DIA_RECEIVED_STATUS_BIT_MASK_INIT            = 0,
   DIA_RECEIVED_STATUS_BIT_MASK_USB_PORT_STATES = (1<<0),
   DIA_RECEIVED_STATUS_BIT_MASK_USB_CURRENT     = (1<<1),
   DIA_RECEIVED_STATUS_BIT_MASK_ALL             = (DIA_RECEIVED_STATUS_BIT_MASK_USB_PORT_STATES | DIA_RECEIVED_STATUS_BIT_MASK_USB_CURRENT)
};

//-----------------------------------------------------------------------------

dia_SrvHandler_USB_PowerSupplyInfoPort::dia_SrvHandler_USB_PowerSupplyInfoPort ( tCString name, tU8 sid, tU16 did )
    : dia_ServiceHandlerUDS( name, sid, did ),mUsbPortPowerStatus(USB_PORT_POWER_STATUS_NOT_AVAILABLE),
      mUsbPortCurrent(USB_PORT_CURRENT_NOT_AVAILABLE),mReceivedStatusBitMask(DIA_RECEIVED_STATUS_BIT_MASK_INIT)
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc( "dia_SrvHandler_USB_PowerSupplyInfoPort::dia_SrvHandler_USB_PowerSupplyInfoPort(void)" );
#endif
}

//-----------------------------------------------------------------------------

dia_SrvHandler_USB_PowerSupplyInfoPort::~dia_SrvHandler_USB_PowerSupplyInfoPort( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IDeviceMGRListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR( "EXCEPTION CAUGHT: dia_SrvHandler_USB_PowerSupplyInfoPort::~dia_SrvHandler_USB_PowerSupplyInfoPort !!!" );
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

bool
dia_SrvHandler_USB_PowerSupplyInfoPort::isValidPort ( dia_eUsbPort portNumer )
{
   bool retVal = false;

   if ((portNumer>USB_PORT_3) || (USB_PORT_UNKNOWN==portNumer))
   {
      DIA_TR_ERR( "isValidPort: portNumer=%d is incorrect", (tU8)portNumer);
   }
   else
   {
      switch(getDID())
      {
         case DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_INFO_PORT_1:
            if (USB_PORT_1==portNumer)
            {
               retVal = true;
            }
         break;

         case DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_INFO_PORT_2:
            if (USB_PORT_2==portNumer)
            {
               retVal = true;
            }
         break;

         case DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_INFO_PORT_3:
            if (USB_PORT_3==portNumer)
            {
               retVal = true;
            }
         break;

         default:
            DIA_TR_ERR( "isValidPort: incorrect DID=%d", getDID());
         break;
      }
   }

   DIA_TR_INF( "isValidPort returned %s (portNumer=%d, DID=0x%04X)", (retVal? "TRUE": "FALSE"), (tU8)portNumer, getDID());

   return retVal;
}

void
dia_SrvHandler_USB_PowerSupplyInfoPort::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc( "dia_SrvHandler_USB_PowerSupplyInfoPort::vProcessRequest" );

   tBool errorDetectedUSBStatus = TRUE;
   tBool errorDetectedUSBCurrent = TRUE;

   //reset all previous values
   mUsbPortPowerStatus = USB_PORT_POWER_STATUS_NOT_AVAILABLE;
   mUsbPortCurrent = USB_PORT_CURRENT_NOT_AVAILABLE;
   mReceivedStatusBitMask = DIA_RECEIVED_STATUS_BIT_MASK_INIT;

   //send request for USB port status
   dia_IDeviceMGR* pIDeviceMGR = NULL;
   if( querySysAdapterInterface<dia_IDeviceMGR>(&pIDeviceMGR) == DIA_SUCCESS )
   {
      DIA_TR_INF( "dia_SrvHandler_USB_PowerSupplyInfoPort::vProcessRequest - querySysAdapterInterface SUCCESS!" );

      if( pIDeviceMGR )
      {
         DIA_TR_INF( "dia_SrvHandler_USB_PowerSupplyInfoPort::vProcessRequest - pDeviceMGR NOT NULL" );

         (void) setSysAdapterListener<dia_IDeviceMGRListener>(this);
         if ( pIDeviceMGR->getDevicesValues() == DIA_SUCCESS )
         {
            errorDetectedUSBStatus = FALSE;
            DIA_TR_INF( "dia_SrvHandler_USB_PowerSupplyInfoPort::vProcessRequest - getDevicesValues SUCCESS!" );
         }
         else
         {
            DIA_TR_INF( "dia_SrvHandler_USB_PowerSupplyInfoPort::vProcessRequest - getDevicesValues FAILED!" );
         }
      }
   }
   else
   {
      DIA_TR_INF( "dia_SrvHandler_USB_PowerSupplyInfoPort::vProcessRequest - querySysAdapterInterface FAILED!" );
   }

   //send request for current through USB port
   dia_IDeviceMGRUSB* pIDVM = 0;
   if ((querySysAdapterInterface<dia_IDeviceMGRUSB>(&pIDVM) == DIA_SUCCESS) && pIDVM)
   {
      (tVoid) setSysAdapterListener<dia_IDeviceMGRUSBListener>(this);
      if ( pIDVM->getUSBPortCurrentResult() != DIA_SUCCESS )
      {
         DIA_TR_ERR("dia_SrvHandler_USB_PowerSupplyInfoPort::vProcessRequest => ERROR: getUSBPortCurrent != DIA_SUCCESS !");
      }
      else
      {
         errorDetectedUSBCurrent = FALSE;
         DIA_TR_INF("dia_SrvHandler_USB_PowerSupplyInfoPort::vProcessRequest => Send Successfully to Server .");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_USB_PowerSupplyInfoPort::vProcessRequest => ERROR: pIDVM == NULL !");
   }

   if ( errorDetectedUSBStatus )
   {
      (void) unsetSysAdapterListener<dia_IDeviceMGRListener>(this);

      //answer will no come for sure
      mReceivedStatusBitMask |= DIA_RECEIVED_STATUS_BIT_MASK_USB_PORT_STATES;

      DIA_TR_ERR( "dia_SrvHandler_USB_PowerSupplyInfoPort: USB status N/A" );
   }

   if ( errorDetectedUSBCurrent )
   {
      (void) unsetSysAdapterListener<dia_IDeviceMGRUSBListener>(this);

      //answer will no come for sure
      mReceivedStatusBitMask |= DIA_RECEIVED_STATUS_BIT_MASK_USB_CURRENT;

      DIA_TR_ERR( "dia_SrvHandler_USB_PowerSupplyInfoPort: USB current N/A" );
   }

   if (errorDetectedUSBStatus && errorDetectedUSBCurrent)
   {
      //send positive response immediately, all values N/A
      assembleResponse();
   }
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

void
dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortStates( const std::vector<dia_tUsbPortStates>& PortStatesVect )
{
   dia_tclFnctTrace trc( "dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortStates" );

   DIA_TR_INF( "dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortStates: PortStatesList.size()=%zu", PortStatesVect.size() );

   (void) unsetSysAdapterListener<dia_IDeviceMGRListener>(this);

   if( !PortStatesVect.empty() )
   {
      std::vector<dia_tUsbPortStates>::const_iterator it = PortStatesVect.begin();

      for(tU8 i=0; it != PortStatesVect.end(); ++it, ++i )
      {
         if ( isValidPort(static_cast<dia_eUsbPort>((*it).PortNo)) )
         {
            DIA_TR_INF( "dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortStates: [i=%d portNo=%d] Get USB port status.", i, (*it).PortNo);

            if (true==((*it).OpenCircuit))
            {
               DIA_TR_INF( "USB PORT NUMBER = %d: USB_PORT_POWER_STATUS_OPEN", (*it).PortNo);
               mUsbPortPowerStatus = USB_PORT_POWER_STATUS_OPEN;
            }
            else if (true==((*it).OverCurrent))
            {
               DIA_TR_INF( "USB PORT NUMBER = %d: USB_PORT_POWER_STATUS_SHORT", (*it).PortNo);
               mUsbPortPowerStatus = USB_PORT_POWER_STATUS_SHORT;
            }
            else if (false==((*it).PowerOn))
            {
               DIA_TR_INF( "USB PORT NUMBER = %d: USB_PORT_POWER_STATUS_NOT_AVAILABLE", (*it).PortNo);
               mUsbPortPowerStatus = USB_PORT_POWER_STATUS_NOT_AVAILABLE;
            }
            else
            {
               DIA_TR_INF( "USB PORT NUMBER = %d: USB_PORT_POWER_STATUS_OK", (*it).PortNo);
               mUsbPortPowerStatus = USB_PORT_POWER_STATUS_OK;
            }
         }
         else
         {
            DIA_TR_INF( "dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortStates [i=%d, port=%d] Port status ignored.", i, (*it).PortNo);
         }
      }
   }
   else
   {
      DIA_TR_ERR( "dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortStates: ERROR: NO ELEMENTS IN VECTOR!" );
   }

   mReceivedStatusBitMask |= DIA_RECEIVED_STATUS_BIT_MASK_USB_PORT_STATES;

   if ( DIA_RECEIVED_STATUS_BIT_MASK_ALL == mReceivedStatusBitMask )
   {
      DIA_TR_INF( "dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortStates: Call assembleResponse()" );
      assembleResponse();
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortCurrent( const std::vector<dia_tUsbPortCurrent>& PortCurrentVect )
{
   dia_tclFnctTrace trc( "dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortCurrent" );

   DIA_TR_INF( "dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortCurrent: PortCurrentList.size()=%zu", PortCurrentVect.size() );

   (void) unsetSysAdapterListener<dia_IDeviceMGRUSBListener>(this);

   if( !PortCurrentVect.empty() )
   {
      std::vector<dia_tUsbPortCurrent>::const_iterator it = PortCurrentVect.begin();

      for(tU8 i=0; it != PortCurrentVect.end(); ++it, ++i )
      {
         if ( isValidPort((*it).PortNo) )
         {
            mUsbPortCurrent = (*it).CurrentInMilliAmpere;

            DIA_TR_INF( "[i=%d portNo=%d] current=0x%04X (decimal %d) - Get current.", i, (*it).PortNo, mUsbPortCurrent, mUsbPortCurrent);
         }
         else
         {
            DIA_TR_INF( "[i=%d, port=%d] Port status ignored.", i, (*it).PortNo);
         }
      }
   }
   else
   {
      DIA_TR_ERR( "dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortCurrent: ERROR: NO ELEMENTS IN VECTOR!" );
   }

   mReceivedStatusBitMask |= DIA_RECEIVED_STATUS_BIT_MASK_USB_CURRENT;

   if ( DIA_RECEIVED_STATUS_BIT_MASK_ALL == mReceivedStatusBitMask )
   {
      DIA_TR_INF( "dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortCurrent: Call assembleResponse()" );
      assembleResponse();
   }
}

//-------------------------------------------------------------------------------------------------------------------

void
dia_SrvHandler_USB_PowerSupplyInfoPort::assembleResponse ()
{
   dia_tclFnctTrace trc( "dia_SrvHandler_USB_PowerSupplyInfoPort::assembleResponse" );

   // Sending back the positive answer
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength( DATA_START + DATA_LENGTH );

   DIA_TR_INF( "mUsbPortPowerStatus = 0x%02X", mUsbPortPowerStatus );
   DIA_TR_INF( "mUsbPortCurrent     = 0x%04X", mUsbPortCurrent );

   (void) oDiagMsgBuffer().vSetDataU8( DATA_START + 0,(tU8) (mUsbPortPowerStatus)         );
   (void) oDiagMsgBuffer().vSetDataU8( DATA_START + 1,(tU8) ((mUsbPortCurrent>>8) & 0xFFU));    //big endian
   (void) oDiagMsgBuffer().vSetDataU8( DATA_START + 2,(tU8) ((mUsbPortCurrent>>0) & 0xFFU));    //big endian

   vResReadyAndQuit();
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortCurrentError (const tU32 errCode )
{
   dia_tclFnctTrace trc( "dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortCurrentError");

   (void) unsetSysAdapterListener<dia_IDeviceMGRUSBListener>(this);

   DIA_TR_ERR( "dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortCurrentError => errCode=0x%08X",errCode);

   //despite error send positive response with N/A values
   mReceivedStatusBitMask |= DIA_RECEIVED_STATUS_BIT_MASK_USB_CURRENT;

   if ( DIA_RECEIVED_STATUS_BIT_MASK_ALL == mReceivedStatusBitMask )
   {
      DIA_TR_INF( "dia_SrvHandler_USB_PowerSupplyInfoPort::vOnUSBPortCurrentError: Call assembleResponse()" );
      assembleResponse();
   }
}
