/*
 * dia_SrvHandler_USB_PowerSupply.cpp
 *
 * Created on: 19.06.2014
 * Author: nce5kor
 *
 * TTFis:> DIA_REQ UDS 00 22 64 20
 *
 */

#include "dia_SrvHandler_USB_PowerSupply.h"

#define DATA_START 3
#define DATA_LENGTH 1

//-------------------------------------------------------------------------------

dia_SrvHandler_USB_PowerSupply::dia_SrvHandler_USB_PowerSupply(tCString name, tU8 sid, tU16 did):
      dia_ServiceHandlerUDS(name,sid,(tU16) did)
{
    dia_tclFnctTrace trc(("dia_SrvHandler_USB_PowerSupply::dia_SrvHandler_USB_PowerSupply" ));
    switch(did){
       case DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_1:
          mDeviceNo = USB_DEVICE_1;
          break;
       case DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_2:
          mDeviceNo = USB_DEVICE_2;
          break;
       case DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_3:
          mDeviceNo = USB_DEVICE_3;
          break;
       default:
          mDeviceNo = USB_DEVICE_1;
          break;
    }
}

//-------------------------------------------------------------------------------

dia_SrvHandler_USB_PowerSupply::~dia_SrvHandler_USB_PowerSupply()
{
    _BP_TRY_BEGIN
    {
        dia_tclFnctTrace trc(("dia_SrvHandler_USB_PowerSupply::~dia_SrvHandler_USB_PowerSupply"));
        (tVoid) unsetSysAdapterListener<dia_IDeviceMGRUSBListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR(("dia_SrvHandler_USB_PowerSupply::~dia_SrvHandler_USB_PowerSupply - Exception caught!"));
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_USB_PowerSupply::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_USB_PowerSupply::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IDeviceMGRUSB* pIDVM = 0;
   if ((querySysAdapterInterface<dia_IDeviceMGRUSB>(&pIDVM) == DIA_SUCCESS) && pIDVM)
   {
      (tVoid) setSysAdapterListener<dia_IDeviceMGRUSBListener>(this);
      if ( pIDVM->getUSBPowerStatusResult(mDeviceNo) != DIA_SUCCESS )
      {
         DIA_TR_ERR("dia_SrvHandler_USB_PowerSupply::vProcessRequest => ERROR: getUSBPowerStatusResult != DIA_SUCCESS !");
      }
      else
      {
         errorDetected = FALSE;
         DIA_TR_INF("dia_SrvHandler_USB_PowerSupply::vProcessRequest => Send Successfully to Server .");
      }
   }
   else
   {
      DIA_TR_ERR(("dia_SrvHandler_USB_PowerSupply::vProcessRequest => ERROR: pIDVM == NULL !"));
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IDeviceMGRUSBListener>(this);
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }

}


/*************************************************************************
*
* FUNCTION: tVoid vOnUSBPowerStatusReadResult()
*
* DESCRIPTION: Request Handler Function
*
* PARAMETER: device - number of USB device (1-3)
*            status - power status (on/off) of device
*
* RETURNVALUE: none
*
*************************************************************************/
tVoid
dia_SrvHandler_USB_PowerSupply::vOnUSBPowerStatusReadResult(dia_eUsbDevice device, dia_eUsbPowerStatus status)
{
   dia_tclFnctTrace trc( "dia_SrvHandler_USB_PowerSupply::vOnUSBPowerStatusReadResult");

   if (device == mDeviceNo)
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      if (status == USB_POWER_OFF)
      {
         DIA_TR_INF("dia_SrvHandler_USB_PowerSupply - USB POWER STATUS: OFF ");
         oDiagMsgBuffer().vSetDataU8(DATA_START + 0, 0x00);
      }
      else
      {
         DIA_TR_INF("dia_SrvHandler_USB_PowerSupply - USB POWER STATUS: ON ");
         oDiagMsgBuffer().vSetDataU8(DATA_START + 0, 0x01);
      }

      (tVoid) unsetSysAdapterListener<dia_IDeviceMGRUSBListener>(this);

      vResReadyAndQuit();
   }
}

/*************************************************************************
*
* FUNCTION: tVoid vOnUSBPowerStatusReadError(const tU32 errCode )
*
* DESCRIPTION: Response Handler Function Error
*
* PARAMETER: errCode: Standard Error Result
*
* RETURNVALUE: none
*
*************************************************************************/
tVoid dia_SrvHandler_USB_PowerSupply::vOnUSBPowerStatusReadError (const tU32 errCode )
{
   dia_tclFnctTrace trc( "dia_SrvHandler_USB_PowerSupply::vOnUSBPowerStatusReadError");

   (tVoid) unsetSysAdapterListener<dia_IDeviceMGRUSBListener>(this);

   DIA_TR_INF( "dia_SrvHandler_USB_PowerSupply::vOnUSBPowerStatusReadError => errCode=%x",errCode);
   oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   vResReadyAndQuit();
}

