/*
 * dia_SrvHandler_TunerXM_BER.cpp
 *
 *  Created on: 16.01.2013
 *      Author: shw2abt
 */
// TTFis:\> DIA_REQ UDS 04 22 61 43

#ifndef DIA_SRVHANDLER_TUNERXM_BER_H_
#include "dia_SrvHandler_TunerXM_BER.h"
#endif


#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 6

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerXM_BER::dia_SrvHandler_TunerXM_BER ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TunerXM_BER",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_SXM_TUNER_BER /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerXM_BER::dia_SrvHandler_TunerXM_BER(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerXM_BER::~dia_SrvHandler_TunerXM_BER ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_ITunerXMListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_TunerXM_BER::~dia_SrvHandler_TunerXM_BER !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_TunerXM_BER::vProcessRequest(const std::vector<tArgsType>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerXM_BER::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_ITunerXM* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_ITunerXM>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_TunerXM_BER::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_TunerXM_BER::vProcessRequest - pInterface OK.");
         (void) setSysAdapterListener<dia_ITunerXMListener>(this);

         if(oDiagMsgBuffer().u16GetDataLength()==DATA_START+DATA_LENGTH){
            DIA_TR_INF("dia_SrvHandler_TunerXM_BER::vProcessRequest - MsgLength OK -> Send here!");
         }

         if ( pInterface->tunerXM_DiagTestModeEnable_Set(true) == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_TunerXM_BER::vProcessRequest - pInterface->tunerXM_DiagTestModeEnable_Set() SUCCESS.");

            if ( pInterface->tunerXM_DiagTestModeData_Get() == DIA_SUCCESS )
            {
             DIA_TR_INF("dia_SrvHandler_TunerXM_BER::vProcessRequest - pInterface->tunerXM_DiagTestModeData_Get() SUCCESS.");
             errorDetected = FALSE;
             } else {
             DIA_TR_INF("dia_SrvHandler_TunerXM_BER::vProcessRequest - pInterface->tunerXM_DiagTestModeData_Get() FAILED.");
             }

         } else {
            DIA_TR_INF("dia_SrvHandler_TunerXM_BER::vProcessRequest - pInterface->tunerXM_DiagTestModeEnable_Set() FAILED.");
         }
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_TunerXM_BER::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_ITunerXMListener>(this);
      DIA_TR_ERR("dia_SrvHandler_TunerXM_BER ---  SEND TO XM TUNER SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerXM_BER::vOnTunerXM_DiagTestModeEnable_Set ( tDiaResult )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerXM_BER::vOnTunerXM_DiagTestModeEnable_Set");
   vResReadyAndQuit();
   DIA_TR_INF("dia_SrvHandler_TunerXM_BER::vOnTunerXM_DiagTestModeEnable_Set SUCCESSFUL");
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerXM_BER::vOnTunerXM_DiagTestModeData_Get ( tU16 BerS1, tU16 BerS2, tU16 BerT )
{
	dia_tclFnctTrace trc("dia_SrvHandler_TunerXM_BER::vOnTunerXM_DiagTestModeData_Get");

	(tVoid) unsetSysAdapterListener<dia_ITunerXMListener>(this);

	oDiagMsgBuffer().vSetPosResp();
	oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

	(tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) (U16_BYTE1(BerS1))));
	(tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 1, ((tU8) (U16_BYTE2(BerS1))));
	(tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 2, ((tU8) (U16_BYTE1(BerS2))));
	(tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 3, ((tU8) (U16_BYTE2(BerS2))));
	(tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 4, ((tU8) (U16_BYTE1(BerT))));
	(tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 5, ((tU8) (U16_BYTE2(BerT))));

	vResReadyAndQuit();
	DIA_TR_INF("dia_SrvHandler_TunerXM_BER::vOnTunerXM_DiagTestModeData_Get SUCCESSFUL");
}

//-----------------------------------------------------------------------------

void dia_SrvHandler_TunerXM_BER::vOnTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_SrvHandler_TunerXM_BER::vOnTimeout(void)");
   (tVoid) unsetSysAdapterListener<dia_ITunerXMListener>(this);
   oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   vResReadyAndQuit();
}

