/*
 * dia_SrvHandler_TunerDAB_Antenna1ServiceID.cpp
 *
 *  Created on: 26.06.2013
 *      Author: shw2abt
 */
// TTFis:\> DIA_REQ UDS 04 22 61 32

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#include "dia_SrvHandler_TunerDAB_Antenna1ServiceID.h"


#define DATA_START 3
#define DATA_LENGTH 4

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerDAB_Antenna1ServiceID::dia_SrvHandler_TunerDAB_Antenna1ServiceID ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TunerDAB_Antenna1ServiceID",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_TUNER_DAB_SERVICE_ID /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerDAB_Antenna1ServiceID::dia_SrvHandler_TunerDAB_Antenna1ServiceID(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerDAB_Antenna1ServiceID::~dia_SrvHandler_TunerDAB_Antenna1ServiceID ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_ITunerDABListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_TunerDAB_Antenna1ServiceID::~dia_SrvHandler_TunerDAB_Antenna1ServiceID !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerDAB_Antenna1ServiceID::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerDAB_Antenna1ServiceID::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_ITunerDAB* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_ITunerDAB>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1ServiceID::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1ServiceID::vProcessRequest - pInterface OK.");
         (tVoid) setSysAdapterListener<dia_ITunerDABListener>(this);

         if(oDiagMsgBuffer().u16GetDataLength()==DATA_START+DATA_LENGTH){
            DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1ServiceID::vProcessRequest - MsgLength OK -> Send here!");
         }

         if ( pInterface->tunerDAB_GetStatus() == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1ServiceID::vProcessRequest - pInterface->tunerAMFM_AntennaStatus_Get() SUCCESS.");
            errorDetected = FALSE;
         } else {
            DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1ServiceID::vProcessRequest - pInterface->tunerAMFM_AntennaStatus_Get() FAILED.");
         }
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1ServiceID::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerDABListener>(this);
      DIA_TR_ERR("dia_SrvHandler_TunerDAB_Antenna1ServiceID ---  SEND TO SAFEATURE TUNER DAB FAILED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerDAB_Antenna1ServiceID::vOnDABStatusServiceID ( tU32 serviceID ){
   dia_tclFnctTrace trc("dia_SrvHandler_TunerDAB_Antenna1ServiceID::vOnDABStatusServiceID");

//   if(serviceID <= 6554 ) {
      (tVoid) unsetSysAdapterListener<dia_ITunerDABListener>(this);
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, U32_BYTE1(serviceID));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 1, U32_BYTE2(serviceID));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 2, U32_BYTE3(serviceID));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 3, U32_BYTE4(serviceID));

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1ServiceID::vOnDABStatusServiceID SUCCESSFUL");
//   } else {
//      DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1ServiceID::vOnDABStatusServiceID FAIL");
//      // Sending back the Negative answer
//      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
//   }

}

