/*
 * dia_SrvHandler_TunerDAB_Antenna1Current.cpp
 *
 *  Created on: 24.10.2012
 *      Author: shw2abt
 */
// TTFis:\> DIA_REQ UDS 04 22 61 36

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_SrvHandler_TunerDAB_Antenna1Current.h"


#define DATA_START 3
#define DATA_LENGTH 2

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerDAB_Antenna1Current::dia_SrvHandler_TunerDAB_Antenna1Current ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TunerDAB_Antenna1Current",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_TUNER_DAB_ANTENNA_CURRENT /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerDAB_Antenna1Current::dia_SrvHandler_TunerDAB_Antenna1Current(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerDAB_Antenna1Current::~dia_SrvHandler_TunerDAB_Antenna1Current ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_TunerDAB_Antenna1Current::~dia_SrvHandler_TunerDAB_Antenna1Current !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerDAB_Antenna1Current::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerDAB_Antenna1Current::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_ITunerMaster* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_ITunerMaster>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1Current::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1Current::vProcessRequest - pInterface OK.");
         (tVoid) setSysAdapterListener<dia_ITunerMasterListener>(this);

         if(oDiagMsgBuffer().u16GetDataLength()==DATA_START+DATA_LENGTH){
            DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1Current::vProcessRequest - MsgLength OK -> Send here!");
         }

         if ( pInterface->tunerDAB_Antenna1Current_Get() == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1Current::vProcessRequest - pInterface->tunerAMFM_AntennaStatus_Get() SUCCESS.");
            errorDetected = FALSE;
         } else {
            DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1Current::vProcessRequest - pInterface->tunerAMFM_AntennaStatus_Get() FAILED.");
         }
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1Current::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
      DIA_TR_ERR(" ---  SEND TO TUNER MASTER SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerDAB_Antenna1Current::vOnTunerDABAntenna1Current_Get ( tU16 antennaCurrent )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerDAB_Antenna1Current::vOnTunerDABAntenna1Current_Get");

   (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);

   if(antennaCurrent <= 6554 )
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      antennaCurrent = (tU16) (antennaCurrent * 10); // as defined in CDD-File

      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) (antennaCurrent >> 8)));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 1, ((tU8) (antennaCurrent)));

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1Current::vOnTunerDABAntenna1Current_Get SUCCESSFUL");
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_TunerDAB_Antenna1Current::vOnTunerDABAntenna1Current_Get FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }

}

//-----------------------------------------------------------------------------

void dia_SrvHandler_TunerDAB_Antenna1Current::vOnTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_SrvHandler_TunerDAB_Antenna1Current::vOnTimeout(void)");
   (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
   oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   vResReadyAndQuit();
}

