/*
 * dia_SrvHandler_TunerAMFM_Frequency.cpp
 *
 *  Created on: 12.10.2012
 *      Author: shw2abt
 */

// TTFis:\> DIA_REQ UDS 04 22 61 01

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#include "dia_SrvHandler_TunerAMFM_Frequency.h"


#define DATA_START 3
#define DATA_LENGTH 4

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerAMFM_Frequency::dia_SrvHandler_TunerAMFM_Frequency ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_TunerAMFM_Frequency",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_TUNER_AMFM_FREQUENCY /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_Frequency::dia_SrvHandler_TunerAMFM_Frequency(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_TunerAMFM_Frequency::~dia_SrvHandler_TunerAMFM_Frequency ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_TunerAMFM_Frequency::~dia_SrvHandler_TunerAMFM_Frequency !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerAMFM_Frequency::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_Frequency::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_ITunerAMFM* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_ITunerAMFM>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_Frequency::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_TunerAMFM_Frequency::vProcessRequest - pInterface OK.");
         (tVoid) setSysAdapterListener<dia_ITunerAMFMListener>(this);

         if(oDiagMsgBuffer().u16GetDataLength()==DATA_START+DATA_LENGTH){
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_Frequency::vProcessRequest - MsgLength OK -> Send here!");
         }

         if ( pInterface->tunerAMFM_attachNotification(DIA_EN_TUNERAMFM_NOTIFICATION_FREQUENCY) == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_Frequency::vProcessRequest - pInterface->tunerAMFM_Frequency_Get() OK.");
            errorDetected = FALSE;
         }
      }
   } else {
      DIA_TR_ERR("dia_SrvHandler_TunerAMFM_Frequency::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
      DIA_TR_ERR(" ---  SEND TO TUNER AMFM SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_TunerAMFM_Frequency::vOnTunerAMFMFrequency_Get ( tU32 frequency )
{
   dia_tclFnctTrace trc("dia_SrvHandler_TunerAMFM_Frequency::vOnTunerAMFMFrequency_Get");

   DIA_TR_INF("dia_SrvHandler_TunerAMFM_Frequency::vOnTunerAMFMFrequency_Get (1) detachNotification");
   dia_ITunerAMFM* pInterface = OSAL_NULL;
   if (querySysAdapterInterface<dia_ITunerAMFM>(&pInterface) == DIA_SUCCESS) {
//      DIA_TR_INF("dia_SrvHandler_TunerAMFM_Frequency::vOnTunerAMFMFrequency_Get - querySysAdapterInterface OK.");
      if (pInterface) {
//         DIA_TR_INF("dia_SrvHandler_TunerAMFM_Frequency::vOnTunerAMFMFrequency_Get - pInterface OK.");
         (tVoid) setSysAdapterListener<dia_ITunerAMFMListener>(this);

         if (pInterface->tunerAMFM_detachNotification(DIA_EN_TUNERAMFM_NOTIFICATION_FREQUENCY) == DIA_SUCCESS) {
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_Frequency::vOnTunerAMFMFrequency_Get - detachNotification() SUCCESS.");
         } else {
            DIA_TR_INF("dia_SrvHandler_TunerAMFM_Frequency::vOnTunerAMFMFrequency_Get - detachNotification() FAILED.");
         }
      }
   }

   DIA_TR_INF("dia_SrvHandler_TunerAMFM_Frequency::vOnTunerAMFMFrequency_Get (2) Send Result To Tester.");

   (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);

   if (frequency != 0xFFFFFFFF)
   { // No meaningful check possible
      oDiagMsgBuffer().vSetPosResp();

      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) (U32_BYTE1(frequency))));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 1, ((tU8) (U32_BYTE2(frequency))));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 2, ((tU8) (U32_BYTE3(frequency))));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 3, ((tU8) (U32_BYTE4(frequency))));

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_Frequency::vOnTunerAMFMFrequency_Get SUCCESSFUL");
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_TunerAMFM_Frequency::vOnTunerAMFMselectActiveTuner FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
