/*
 * dia_SrvHandler_SDCard1SlotState.cpp
 *
 *  Created on: 24.07.2012
 *      Author: sta8hi
 */
// TTFis: DIA_REQ UDS 04 22 63 10

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_SrvHandler_SDCard1SlotState.h"

#ifndef __INCLUDED_DIA_INTERFACE_DEVICE_MANAGER_LISTENER__
#include "common/interfaces/dia_IDeviceMGRListener.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 2

//-----------------------------------------------------------------------------

dia_SrvHandler_SDCard1SlotState::dia_SrvHandler_SDCard1SlotState ( void )
    : dia_ServiceHandlerUDS( "dia_SrvHandler_SDCard1SlotState", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_SD_CARD_1_SLOT_STATE )

{
   dia_tclFnctTrace trc( "dia_SrvHandler_SDCard1SlotState::dia_SrvHandler_SDCard1SlotState(void)" );
}

//-----------------------------------------------------------------------------

dia_SrvHandler_SDCard1SlotState::~dia_SrvHandler_SDCard1SlotState( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IDeviceMGRListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR( "EXCEPTION CAUGHT: dia_SrvHandler_SDCard1SlotState::~dia_SrvHandler_SDCard1SlotState !!!" );
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_SDCard1SlotState::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc( "dia_SrvHandler_SDCard1SlotState::vProcessRequest" );

   tBool errorDetected = TRUE;
   dia_IDeviceMGR* pDeviceMGR = 0;
   if ( querySysAdapterInterface<dia_IDeviceMGR>(&pDeviceMGR) == DIA_SUCCESS )
   {
      if ( pDeviceMGR )
      {
         (void) setSysAdapterListener<dia_IDeviceMGRListener>(this);
         if ( pDeviceMGR->getSDCardDiagValues() == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      }
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IDeviceMGRListener>(this);
      DIA_TR_ERR( "dia_SrvHandler_SDCard1SlotState ---  SEND TO Media Manager Component failed!!!!" );
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_SDCard1SlotState::vOnSDStates( const std::vector<dia_tSdcStates>& SdcStatesList )
{
   tBool bRetCorrect = FALSE;

   dia_tclFnctTrace trc( "dia_SrvHandler_SDCard1SlotState::vOnSDStates" );

   (void) unsetSysAdapterListener<dia_IDeviceMGRListener>(this);

   std::vector<dia_tSdcStates>::const_iterator it = SdcStatesList.begin();

   if( !SdcStatesList.empty() )
   {
      for(int i=0; it != SdcStatesList.end(); ++it, ++i )
      {
         dia_tSdcStates oSdcStates = (*it);
         DIA_TR_INF( "dia_SrvHandler_SDCard1SlotState::vOnSDStates- [%d] Slot No    = %d", i, oSdcStates.SlotNo );
         DIA_TR_INF( "dia_SrvHandler_SDCard1SlotState::vOnSDStates- [%d] Slot state = %d", i, oSdcStates.SlotState );
         DIA_TR_INF( "dia_SrvHandler_SDCard1SlotState::vOnSDStates- [%d] Write prot = %d", i, oSdcStates.WriteProtectionState );

         if(   ( oSdcStates.SlotNo              == 1 )                                 // Check if the slot number is 1
            && ( oSdcStates.SlotState           < DIA_EN_DEVMGR_SDC_SLOT_STATE_COUNT ) // Check for correct slot state
            && (oSdcStates.WriteProtectionState < DIA_EN_DEVMGR_SDC_WP_STATE_COUNT )   // Check for correct write protection state
           )
         {
            tU8   u8MsgByte;
            bRetCorrect = TRUE;
            oDiagMsgBuffer().vSetPosResp();
            oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

            switch( oSdcStates.SlotState )
            {
               case DIA_EN_DEVMGR_SDC_SLOT_STATE_INSERTED:
                  u8MsgByte = 1;
                  break;
               default:
               case DIA_EN_DEVMGR_SDC_SLOT_STATE_REMOVED:
                  u8MsgByte = 0;
                  break;
            }
            (void)oDiagMsgBuffer().vSetDataU8( DATA_START + 0, u8MsgByte );
            switch( oSdcStates.WriteProtectionState )
            {
               case DIA_EN_DEVMGR_SDC_WP_STATE_NOT_PROTECTED:
                  u8MsgByte = 0;
                  break;
               case DIA_EN_DEVMGR_SDC_WP_STATE_PROTECTED:
               default:
                  u8MsgByte = 1;
                  break;
            }
            (void)oDiagMsgBuffer().vSetDataU8( DATA_START + 1, u8MsgByte );
         }

      }  // for()
   }  // if list not empty

   if( bRetCorrect )
   {
      vResReadyAndQuit();
      DIA_TR_INF( "dia_SrvHandler_SDCard1SlotState::vOnSDStates SUCCESSFUL" );
   }
   else
   {
      DIA_TR_INF( "dia_SrvHandler_SDCard1SlotState::vOnSDStates FAIL" );
      // Sending back the Negative answer
      vSendNegativeResponse( DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT );
   }
}

