/*
 * dia_SrvHandler_ReadTotalWrittenBlockCount.cpp
 *
 */
#ifndef __INCLUDED_DIA_SRVHANDLER_READTOTALWRITTENBLOCKCOUNT__
#include "dia_SrvHandler_ReadTotalWrittenBlockCount.h"
#endif

#ifndef DIA_BASHCOMMAND_H_
#include "common/framework/application/dia_BashCommand.h"
#endif

#include <fstream>
#include <sstream>

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadTotalWrittenBlockCount::dia_SrvHandler_ReadTotalWrittenBlockCount()
    : dia_ServiceHandlerUDS("dia_SrvHandler_ReadTotalWrittenBlockCount",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_EMMC_WRITTEN_BYTES_COUNT /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadTotalWrittenBlockCount::dia_SrvHandler_ReadTotalWrittenBlockCount()");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadTotalWrittenBlockCount::~dia_SrvHandler_ReadTotalWrittenBlockCount()
{
}

// return emmc data file name
std::string dia_SrvHandler_ReadTotalWrittenBlockCount::getFilename() const
{
   std::string name("Total_blkcount.txt");
   return name;
}

#ifndef __DIA_UNIT_TESTING__
// concat file and path based on mmc number
std::string dia_SrvHandler_ReadTotalWrittenBlockCount::getFilePath(std::string const& file) const
{
   std::string path("/var/opt/bosch/persistent/excessive_write/");
   path += file;
   return path;
}
#endif

std::vector<tU8> dia_SrvHandler_ReadTotalWrittenBlockCount::getDeviceNode(std::string const& src) const
{
   std::string::size_type idx = src.find(":");
   std::vector<tU8> deviceNode(32, 0);
   if(idx != std::string::npos)
   {
      std::string strDeviceNode = src.substr(0, idx-1);
      DIA_TR_INF("dia_SrvHandler_ReadTotalWrittenBlockCount: ---  device node %s", strDeviceNode.c_str());
      deviceNode.assign(strDeviceNode.begin(), strDeviceNode.end());
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_ReadTotalWrittenBlockCount: ---  device node not found in %s!", src.c_str());
   }
   return deviceNode;
}

std::vector<tU8> dia_SrvHandler_ReadTotalWrittenBlockCount::getWrittenBytes(std::string const& src) const
{
   std::string::size_type idx = src.find(":");
   tU64 iBytes = 0;
   if(idx != std::string::npos)
   {
      std::string strWrittenBytes = src.substr(idx+1, src.size() - (idx+1));
      DIA_TR_INF("dia_SrvHandler_ReadTotalWrittenBlockCount: ---  written bytes %s", strWrittenBytes.c_str());
      std::stringstream ss(strWrittenBytes);
      ss >> std::skipws >> iBytes;
   }
   std::vector<tU8> writtenBytes(8, 0);
   writtenBytes[7] = iBytes & 0xff;
   writtenBytes[6] = (iBytes >> 8) & 0xff;
   writtenBytes[5] = (iBytes >> 16) & 0xff;
   writtenBytes[4] = (iBytes >> 24) & 0xff;
   writtenBytes[3] = (iBytes >> 32) & 0xff;
   writtenBytes[2] = (iBytes >> 40) & 0xff;
   writtenBytes[1] = (iBytes >> 48) & 0xff;
   writtenBytes[0] = static_cast<tU8>((iBytes >> 56) & 0xff);

   return writtenBytes;
}

#ifndef __DIA_UNIT_TESTING__
std::vector<tU8> dia_SrvHandler_ReadTotalWrittenBlockCount::getEmmcNode() const
{
   //Write the emmc node name into file
   std::string filename = "emmc_node";
   std::string generateLinkCmd = "/opt/bosch/base/bin/diag_generate_link.sh " + filename + " /var/opt/bosch/dynamic/diagnosis";
   std::vector<tU8> emmc_node(32, 0);

   uint8_t generateEmmcNodefile = dia_BashCommand::executeCommand(generateLinkCmd);
   if (generateEmmcNodefile != 0) {
      DIA_TR_ERR("dia_SrvHandler_ReadTotalWrittenBlockCount: Writing emmc node name into file FAILED!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      return std::vector<tU8>(); //returning empty vector
   }

   std::ifstream emmcNodeFile("/var/opt/bosch/dynamic/diagnosis/emmc_node");
   std::string strEmmcNode;
   emmcNodeFile >> strEmmcNode;
   DIA_TR_INF("dia_SrvHandler_ReadTotalWrittenBlockCount: ---  emmcNode %s", strEmmcNode.c_str());
   emmc_node.assign(strEmmcNode.begin(), strEmmcNode.end());
   return emmc_node;
}
#endif

void dia_SrvHandler_ReadTotalWrittenBlockCount::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadTotalWrittenBlockCount::vProcessRequest");
   std::string file = getFilename();
   // construct file path and name
   std::string path = getFilePath(file);
   DIA_TR_INF("dia_SrvHandler_ReadTotalWrittenBlockCount: ---  reading %s", path.c_str());
   // open file
   std::string db;
   std::ifstream emmcFile(path.c_str());
   std::vector<tU8> emmcNode = getEmmcNode();
   if(emmcNode.empty())
   {
      return;
   }
   std::vector<tU8> deviceNode(32, 0);
   while(getline(emmcFile, db))
   {
      // get device node
      deviceNode = getDeviceNode(db);
      //EMMC node found in the file
      if (deviceNode == emmcNode)
      {
         DIA_TR_INF("dia_SrvHandler_ReadTotalWrittenBlockCount: ---  file %s!", db.c_str());
         // get written bytes
         std::vector<tU8> writtenBytes = getWrittenBytes(db);
         DIA_TR_INF(" ---  READ EMMC Written Block Total SUCCESS!");
         const tU16 DATA_START = 3;
         const tU16 DATA_LENGTH = 160;
         oDiagMsgBuffer().vSetPosResp();
         oDiagMsgBuffer().vSetDataLength(static_cast<tU16>((DATA_START + DATA_LENGTH) & 0xffff));
         oDiagMsgBuffer().setDataArray((size_t)DATA_START, 32, deviceNode.begin());
         oDiagMsgBuffer().setDataArray((size_t)(DATA_START+32), writtenBytes.size(), writtenBytes.begin());
         std::vector<tU8> emptyNode(32, 0);
         std::vector<tU8> emptyBytes(8, 0);
         oDiagMsgBuffer().setDataArray(emptyNode.size(), emptyNode.begin());
         oDiagMsgBuffer().setDataArray(emptyBytes.size(), emptyBytes.begin());
         oDiagMsgBuffer().setDataArray(emptyNode.size(), emptyNode.begin());
         oDiagMsgBuffer().setDataArray(emptyBytes.size(), emptyBytes.begin());
         oDiagMsgBuffer().setDataArray(emptyNode.size(), emptyNode.begin());
         oDiagMsgBuffer().setDataArray(emptyBytes.size(), emptyBytes.begin());

         vResReadyAndQuit();
         return;
      }
   }
   //EMMC node not found in file
   DIA_TR_ERR(" ---  READ EMMC BLOCK COUNT DATA FAILED-INVALID FILE CONTENT!");
   vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
}

//-----------------------------------------------------------------------------

