/*!
 * \file       dia_SrvHandler_ReadRefreshStatusManagement.h
 *
 * \brief      CM Diag Servicehandler to eMMC refresh status information
 *
 * \component  Diagnostics
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef dia_SrvHandler_ReadRefreshStatusManagement_H_
#define dia_SrvHandler_ReadRefreshStatusManagement_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

/**
 * \brief ServiceHandler to read eMMC refresh status information
 * \details CM Diagnostic UDS based service to read eMMC refresh cycle
 *          management information.
 *          See CM Basevariant: 22 66 38
 * \ingroup    diaServicesCommon
 */
class dia_SrvHandler_ReadRefreshStatusManagement
   : public dia_ServiceHandlerUDS
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ReadRefreshStatusManagement);

public:
   //! class constructor
   dia_SrvHandler_ReadRefreshStatusManagement();

   //! class destructor
   virtual ~dia_SrvHandler_ReadRefreshStatusManagement ();

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/);

private:
   void  getCheckBytes(std::ifstream&, std::vector<tU32>&) const;
   std::string getFilename() const;
   std::string getFilePath(std::string const&) const;
   std::vector<tU8> getDeviceNode(std::string const&) const;
   std::vector<tU8> getWrittenBytes(std::string const&) const;
};

#endif /* dia_SrvHandler_ReadRefreshStatusManagement_H_ */
