/*!
 * \file       dia_SrvHandler_ReadRefreshStatusManagement.cpp
 *
 * \brief      CM Diag Servicehandler to eMMC refresh status information
 *
 * \component  Diagnostics
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_SRVHANDLER_READREFRESHSTATUSMANAGEMENT__
#include "dia_SrvHandler_ReadRefreshStatusManagement.h"
#endif

#include <fstream>
#include <sstream>

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadRefreshStatusManagement::dia_SrvHandler_ReadRefreshStatusManagement()
    : dia_ServiceHandlerUDS("dia_SrvHandler_ReadRefreshStatusManagement",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_EMMC_REFRESH_STATUS /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadRefreshStatusManagement::dia_SrvHandler_ReadRefreshStatusManagement()");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadRefreshStatusManagement::~dia_SrvHandler_ReadRefreshStatusManagement()
{
}

// return emmc data file name
std::string dia_SrvHandler_ReadRefreshStatusManagement::getFilename() const
{
   std::string name("metadata.txt");
   return name;
}

// concat file and path based on mmc number
#ifndef __DIA_UNIT_TESTING__
std::string dia_SrvHandler_ReadRefreshStatusManagement::getFilePath(std::string const& file) const
{
   std::string path("/var/opt/bosch/persistent/emmc_refresh/");
   path += file;
   return path;
}
#endif

void  dia_SrvHandler_ReadRefreshStatusManagement::getCheckBytes(std::ifstream& ss, std::vector<tU32>& checkBytes) const
{
   const size_t checkSize = 9; // 9 uint32_t entries in "checksum"
   checkBytes.assign(checkSize + 1, 0);
   int data = 0;
   for(size_t i = 0; i < checkSize; ++i)
   {
      ss >> std::hex >> data;
      ss.ignore();
      checkBytes[i] = (static_cast<tU32>(data));
   }
}

void dia_SrvHandler_ReadRefreshStatusManagement::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadRefreshStatusManagement::vProcessRequest");
   std::string file = getFilename();
   // construct file path and name
   std::string path = getFilePath(file);
   DIA_TR_INF("dia_SrvHandler_ReadRefreshStatusManagement: ---  reading %s", path.c_str());
   // open file
   std::ifstream emmcFile(path.c_str());
   std::vector<tU32> values;
   while(values.size() != 8)
   {
      int data;
      emmcFile >> data;
      emmcFile.ignore();
      values.push_back(static_cast<tU32>(data));
   }
   std::vector<tU32> checkBytes;
   getCheckBytes(emmcFile, checkBytes);
   const tU16 DATA_START = 3;
   const tU16 DATA_LENGTH = 52;
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(static_cast<tU16>((DATA_START + DATA_LENGTH) & 0xffff));
   oDiagMsgBuffer().setDataU32BigEndian (DATA_START,    values[0]);
   oDiagMsgBuffer().setDataU32BigEndian (DATA_START+4,  values[1]);
   oDiagMsgBuffer().setDataU8           (DATA_START+8,  static_cast<tU8> (values[2]));
   oDiagMsgBuffer().setDataU8           (DATA_START+9,  static_cast<tU8> (values[3]));
   oDiagMsgBuffer().setDataU16BigEndian (DATA_START+10, static_cast<tU16>(values[4]));
   oDiagMsgBuffer().setDataU8           (DATA_START+12, static_cast<tU8> (values[5]));
   oDiagMsgBuffer().setDataU8           (DATA_START+13, static_cast<tU8> (values[6]));
   oDiagMsgBuffer().setDataU16BigEndian (DATA_START+14, static_cast<tU16>(values[7]));
   oDiagMsgBuffer().setDataU32BigEndian (DATA_START+16, checkBytes[0]);
   oDiagMsgBuffer().setDataU32BigEndian (DATA_START+20, checkBytes[1]);
   oDiagMsgBuffer().setDataU32BigEndian (DATA_START+24, checkBytes[2]);
   oDiagMsgBuffer().setDataU32BigEndian (DATA_START+28, checkBytes[3]);
   oDiagMsgBuffer().setDataU32BigEndian (DATA_START+32, checkBytes[4]);
   oDiagMsgBuffer().setDataU32BigEndian (DATA_START+36, checkBytes[5]);
   oDiagMsgBuffer().setDataU32BigEndian (DATA_START+40, checkBytes[6]);
   oDiagMsgBuffer().setDataU32BigEndian (DATA_START+44, checkBytes[7]);
   oDiagMsgBuffer().setDataU32BigEndian (DATA_START+48, checkBytes[8]);
   vResReadyAndQuit();
}

//-----------------------------------------------------------------------------
