/*!
 * \file       dia_SrvHandler_ReadEmmcJedecEcsdData.h
 *
 * \brief      CM Diag Servicehandler to read Extended CSD data for eMMC
 *
 * \component  Diagnostics
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef DIA_SRVHANDLER_READEMMCJEDECECSDDATA_H_
#define DIA_SRVHANDLER_READEMMCJEDECECSDDATA_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

/**
 * \brief ServiceHandler to read eMMC Extended CSD data
 * \details CM Diagnostic UDS based service to read eMMC extended CSD
 *          data for field-data-evaluation
 *          See CM Basevariant: 22 66 32
 * \ingroup    diaServicesCommon
 */
class dia_SrvHandler_ReadEmmcJedecEcsdData
   : public dia_ServiceHandlerUDS
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ReadEmmcJedecEcsdData);

public:
   //! class constructor
   dia_SrvHandler_ReadEmmcJedecEcsdData ();

   //! class destructor
   virtual ~dia_SrvHandler_ReadEmmcJedecEcsdData ();

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/);

private:
   static const size_t registerSize = 1024;
   std::string getFilePath(std::string) const;
};

#endif /* DIA_SRVHANDLER_READEMMCJEDECECSDDATA_H_ */
