/*
 * dia_SrvHandler_ReadDataByMemory.cpp
 *
 *  Created on: 08.05.2012
 *      Author: shw2abt
 */

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

// TTFis: DIA_REQ UDS 07 23 12 00 01 02
#ifndef dia_SrvHandler_ReadDataByMemory_H_
#include "dia_SrvHandler_ReadDataByMemory.h"
#endif

#ifndef __INCLUDED_DIA_NATIVE_KDS_INTERFACE__
#include "common/framework/config/dia_IKDS.h"
#endif

#define DATA_START 5
#define MSG_DATA_OFFSET 3								// Offset from oDiagMsgBuffer-start to 1st data-byte (e.g. MemorySize-Byte)

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadDataByMemory::dia_SrvHandler_ReadDataByMemory ( tVoid )
   : dia_ServiceHandlerUDS("dia_SrvHandler_ReadDataByMemory",DIA_C_U8_UDS_SID_READ_MEMORY_BY_ADDRESS,(tU8) 0x12)
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadDataByMemory::dia_SrvHandler_ReadDataByMemory(tCString,tU8,tU8)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_ReadDataByMemory::~dia_SrvHandler_ReadDataByMemory ( tVoid )
{}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_ReadDataByMemory::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_ReadDataByMemory::vOnProcessRequest");
   const tU16 expectedReqLength = 6;

   if (expectedReqLength!=oDiagMsgBuffer().u16GetDataLength())
   {
      // Sending back the Negative answer
      DIA_TR_ERR("dia_SrvHandler_ReadDataByMemory Incorrect length of inputs. Actual length %d, expected is %d", oDiagMsgBuffer().u16GetDataLength(), expectedReqLength);
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      return;
   }

   //check size of memoryAddress and memorySize (according to UDS ISO-14229-1)
   tU8 addressAndLengthFormatIdentifier = oDiagMsgBuffer().u8GetData(2);

   if (0x12!=addressAndLengthFormatIdentifier)
   {
      // Sending back the Negative answer
      DIA_TR_ERR("dia_SrvHandler_ReadDataByMemory This request is not supported.");
      DIA_TR_ERR("Actual addressAndLengthFormatIdentifier is 0x%02X and expected is 0x12.", addressAndLengthFormatIdentifier);
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      return;
   }

   // Initialisierung
   tU8 u8kdsData[DIA_PROP_CCA_MSG_MAX_PAYLOAD] = { 0 };
   (tVoid) ::memset(u8kdsData, 0, DIA_PROP_CCA_MSG_MAX_PAYLOAD);
   tDiaResult retCode = DIA_FAILED;

   // extract the KDS key
   tU8 u8KDSAddress[2] = { 0, 0 };
   u8KDSAddress[0]     = oDiagMsgBuffer().u8GetData(0 + MSG_DATA_OFFSET); // -> Target-Address in the KDS (Group)
   u8KDSAddress[1]     = oDiagMsgBuffer().u8GetData(1 + MSG_DATA_OFFSET); // -> ID inside the Group
   tU16 u16KDSAddress  = U8_2_U16(u8KDSAddress[0], u8KDSAddress[1]);

   // extract the data size to be read
   tU16 u16KDS_Size = oDiagMsgBuffer().u8GetData(2 + MSG_DATA_OFFSET);

   dia_IKDS* pKDS = 0;
   if (queryConfMgrInterface<dia_IKDS>(&pKDS) == DIA_SUCCESS)
   {
      DIA_TR_INF("dia_SrvHandler_ReadDataByMemory::vProcessRequest - Trying to read entry 0x%x with length 0x%x", u16KDSAddress, u16KDS_Size);
      retCode = pKDS->readKDS(u16KDSAddress, u8kdsData, u16KDS_Size);
      if (retCode == DIA_SUCCESS)
      {
         DIA_TR_INF("dia_SrvHandler_ReadDataByMemory::vProcessRequest - Start reading Data.");
         // a size of zero indicates that we are requesting the current kds item size 
         // the size will be returned in u8kdsData[0]
         if(u16KDS_Size == 0)
         {
            u16KDS_Size = 1;
         }
         // Build the positive answer
         oDiagMsgBuffer().vSetPosResp();
         oDiagMsgBuffer().vSetDataLength(static_cast<tU16>(DATA_START + u16KDS_Size));
         for (tU16 i = 0; i < u16KDS_Size; ++i)
         {
            (tVoid) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START+i), u8kdsData[i]);
         }
         DIA_TR_INF("dia_SrvHandler_ReadDataByMemory::vProcessRequest - End reading Data.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_ReadDataByMemory::vProcessRequest - Requesting ConfigManager queryConfMgrInterface FAILED.");
   }

   // "RETURN"
   if (retCode == DIA_SUCCESS)
   {
      // Sending back the positive answer
      DIA_TR_INF("dia_SrvHandler_ReadDataByMemory::vProcessRequest SUCCESSFUL");
      vResReadyAndQuit();
   }
   else if(retCode == DIA_E_INVALID_LENGTH)
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandler_ReadDataByMemory::vProcessRequest FAIL");
      vSendNegativeResponse(DIA_E_U8_UDS_OUT_OF_RANGE);
   }
   else
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandler_ReadDataByMemory::vProcessRequest FAIL");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

