/**
 * \file    dia_SrvHandler_ReadAdcEcall.h
 *
 * \brief   This file contains the definition of the dia_SrvHandlerGenericIdentADCRead class,
 *          that provides a generic service handler that can be used to process
 *          identification requests that require to retrieve a single property from
 *          the ConfigManager.
 *
 * \author
 * \date    2012/04/27
 *
 * \copyright Robert Bosch Car Multimedia 2012
 */

#ifndef DIA_SRVHANDLERADCREADECALL_H_
#define DIA_SRVHANDLERADCREADECALL_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#if 0

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#endif
/**
 * \class   dia_SrvHandler_ReadAdcEcall
 *
 * \brief   Generic service handler to process Identification request
 *
 *          This class provides a generic service handler that can be used to process
 *          identification requests that need to read a single property from
 *          the ConfigManager module.
 *
 * \ingroup diaServicesCommon
 */

class dia_SrvHandler_ReadAdcEcall
    : public dia_ServiceHandlerUDS
{

   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_ReadAdcEcall);


public:

	//! class constructor
   	dia_SrvHandler_ReadAdcEcall ( void );

	/**
	  * \brief    	handle the received request
	  *
	  *				Function receives the message via the oDiagMsgBuffer and send it to the SA.
	  *
	  * \param[in]	void*     -
	  * \param[in]	void*     -
	  */

    virtual tVoid vProcessRequest ( const std::vector<tArgsType>& vecArgs );

	protected:
	//! class destructor
	virtual ~dia_SrvHandler_ReadAdcEcall(void);
};

#endif /* DIA_SRVHANDLERADCREAD_H_ */
