/**
 * \file      dia_SrvHandler_RadioTypeApprovalModeWrite.h
 *
 * \author    bsu9kor
 * \date      25.02.2016
 *
 */
//TTFis:> DIA_REQ UDS 05 2E 81 69 <00/01>

#ifndef DIA_SRVHANDLER_RADIO_TYPE_APPROVAL_MODE_WRITE_H_
#include "common/services/uds/production/dia_SrvHandler_RadioTypeApprovalModeWrite.h"
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_FILE__
#include "common/framework/application/dia_File.h"
#endif

#include <unistd.h> //lint !e451 !e537 repeatedly included header file without standard include guard

static tCString FILEPATH = "/var/opt/bosch/dynamic/connectivity/bt_module/rta_enable" ;
#ifdef VARIANT_S_FTR_ENABLE_SET_FILE_GROUP_OSAL_BY_ID
#define SET_FILE_GROUP_OSAL(fileObj) fileObj.setGroupByID(10101)
#else
#define SET_FILE_GROUP_OSAL(fileObj) fileObj.setGroupByName("aid_connectivity_dir")
#endif

#define DATA_LENGHTH 		((tU8)5)
#define ENABLED 			0x01
#define DISABLED			0x00
#define MSG_DATA_OFFSET 	4
#define DATA_START 			3

//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    dia_SrvHandler_RadioTypeApprovalModeWrite (Class constructor)
*
* DESCRIPTION: Invokes the class with appropriate Class name, SID, DID
*
* PARAMETER:   void
*
* RETURNVALUE: NA
*
******************************************************************************/
dia_SrvHandler_RadioTypeApprovalModeWrite::dia_SrvHandler_RadioTypeApprovalModeWrite ( void )
   : dia_ServiceHandlerUDS("dia_SrvHandler_RadioTypeApprovalModeWrite",DIA_C_U8_UDS_SID_WRITE_DATA_BY_IDENTIFIER,DIA_C_U16_DID_RADIO_TYPE_APPROVAL_MODE)
{
   dia_tclFnctTrace trc("dia_SrvHandler_RadioTypeApprovalModeWrite::dia_SrvHandler_RadioTypeApprovalModeWrite");
}
//------------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    vProcessRequest
*
* DESCRIPTION: process the received request
*
* PARAMETER:   vecrAgs
*
* RETURNVALUE: NA
*
******************************************************************************/
void
dia_SrvHandler_RadioTypeApprovalModeWrite::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_WriteRadioTypeApprovalMode::vOnProcessRequest");
   bool result = false;
   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
   if ( dataLength != DATA_LENGHTH )
   {
	   vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
	   return;
   }
   if(system("usermod -a -G aid_connectivity_dir diag")) //adding diag user to group aid_connectivity_dir
   {
	   DIA_TR_ERR("#####DIAG USER NOT ADDED TO GROUP aid_connectivity_dir#####");
	   //NORMAL_M_ASSERT_ALWAYS();
   }
   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();
   switch(pU8[MSG_DATA_OFFSET])
   {
      case ENABLED:
      {
    	  DIA_TR_INF("dia_SrvHandler_WriteRadioTypeApprovalMode:Creating File \"%s\"",FILEPATH);
    	  dia_File FlagFile(FILEPATH);
    	  if (DIA_SUCCESS != FlagFile.open("w")) //create the FlagFile
    	  {
    		  DIA_TR_INF("OPENING OF FILE \"%s\" FAILED - Returning Negative response !! #####", FILEPATH);
    	  }
    	  if (DIA_SUCCESS != FlagFile.changeMode(DIA_C_FILE_MODE_USER_RW|DIA_C_FILE_MODE_GROUP_RW)) //Change the permissions
		  {
			  DIA_TR_INF("dia_SrvHandler_WriteRadioTypeApprovalMode:### ERROR. changeMode() failed for %s #### - Returning Negative response", FILEPATH);
		  }
    	  if(DIA_SUCCESS == SET_FILE_GROUP_OSAL(FlagFile)) //change the ownership
    	  {
    		  DIA_TR_INF("dia_SrvHandler_WriteRadioTypeApprovalMode:FILE OWNERSHIP CHANGED");
    		  result = true;
    	  }
    	  else
    	  {
    		  result = true;//remove this line once group is available--Currently returns positive response though group dosen't exist.
    		  DIA_TR_ERR("#####FILE OWNERSHIP NOT CHANGED - Group doesn't exist#####");
    		  //NORMAL_M_ASSERT_ALWAYS();
    	  }
		  FlagFile.close(); //Close the File
		  DIA_TR_INF("Perform double sync for file system");
		  sync();//sync() is always successful
		  OSAL_s32ThreadWait(100);
		  sync();
		  OSAL_s32ThreadWait(100);
	   break;
      }
      case DISABLED:
      {
    	  dia_File FlagFile(FILEPATH);
    	  if(DIA_SUCCESS == FlagFile.remove())
		  {
			  DIA_TR_INF("dia_SrvHandler_RadioTypeApprovalModeWrite:FILE DELETION SUCCESS");
			  result = true;
		  }
		  else
		  {
			  DIA_TR_INF("dia_SrvHandler_RadioTypeApprovalModeWrite:FILE DELETION FAILED");
		  }
    	  break;
      }
      default:
      {
    	break;
      }
   }
   if(result)
   {
	   // Sending back the positive answer
	   oDiagMsgBuffer().vSetPosResp();
	   oDiagMsgBuffer().vSetDataLength(DATA_START);
	   vResReadyAndQuit();
   }
   else
   {
	   // Sending back the negative answer
	   vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
   return;
}
//---------------------------------------------------------------------------------------------

