/*
 * dia_SrvHandler_RVC_ControlLineStatus.cpp
 *
 *  Created on: 18.12.2012
 *      Author: shw2abt
 */
// TTFis:\> DIA_REQ UDS 04 22 10 21

#include "dia_SrvHandler_RVC_ControlLineStatus.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 1

//-----------------------------------------------------------------------------

dia_SrvHandler_RVC_ControlLineStatus::dia_SrvHandler_RVC_ControlLineStatus ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandler_RVC_ControlLineStatus",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,DIA_C_U16_DID_RBCM_RVC_CONTROL_LINE_STATUS /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_RVC_ControlLineStatus::dia_SrvHandler_RVC_ControlLineStatus(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_RVC_ControlLineStatus::~dia_SrvHandler_RVC_ControlLineStatus ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IRVCListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_RVC_ControlLineStatus::~dia_SrvHandler_RVC_ControlLineStatus !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_RVC_ControlLineStatus::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_RVC_ControlLineStatus::vProcessRequest");
   tBool errorDetected = TRUE;

   dia_IRVC* pInterface = OSAL_NULL;
   if ( querySysAdapterInterface<dia_IRVC>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_RVC_ControlLineStatus::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_RVC_ControlLineStatus::vProcessRequest - pInterface OK.");
         (void) setSysAdapterListener<dia_IRVCListener>(this);

         if(oDiagMsgBuffer().u16GetDataLength()==DATA_START+DATA_LENGTH)
         {
            DIA_TR_INF("dia_SrvHandler_RVC_ControlLineStatus::vProcessRequest - MsgLength OK -> Send here!");
         }

         if ( pInterface->getRVCConnectionInfo() == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_RVC_ControlLineStatus::vProcessRequest - getRVCConnectionInfo() SUCCESS.");
            errorDetected = FALSE;
         }
         else
         {
            DIA_TR_INF("dia_SrvHandler_RVC_ControlLineStatus::vProcessRequest - getRVCConnectionInfo() FAILED.");
         }
      }
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_RVC_ControlLineStatus::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IRVCListener>(this);
      DIA_TR_ERR("dia_SrvHandler_RVC_ControlLineStatus ---  SEND TO RVC SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

void
dia_SrvHandler_RVC_ControlLineStatus::vOnRVCPowerSupplyStatus ( dia_eRVC_pwrSupplyStatus rvc_pwrSuppy )
{
   dia_tclFnctTrace trc("dia_SrvHandler_RVC_ControlLineStatus::vOnRVCPowerSupplyStatus");

   (void) unsetSysAdapterListener<dia_IRVCListener>(this);

   if( rvc_pwrSuppy < DIA_EN_RVC_PWR_SUPPLY_COUNT )
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      switch(rvc_pwrSuppy)
      {
         case DIA_EN_RVC_PWR_SUPPLY_UNKNOWN:
            (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0xFF));
            DIA_TR_INF("vOnRVCPowerSupplyStatus => DIA_EN_RVC_PWR_SUPPLY_UNKNOWN");
         break;

         case DIA_EN_RVC_PWR_SUPPLY_OK:
            (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x00));
            DIA_TR_INF("vOnRVCPowerSupplyStatus => DIA_EN_RVC_PWR_SUPPLY_OK");
         break;

         case DIA_EN_RVC_PWR_SUPPLY_OPENLOAD:
            (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x01));
            DIA_TR_INF("vOnRVCPowerSupplyStatus => DIA_EN_RVC_PWR_SUPPLY_OPENLOAD");
         break;

         case DIA_EN_RVC_PWR_SUPPLY_SHORTCIRCUIT:
            (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x02));
            DIA_TR_INF("vOnRVCPowerSupplyStatus => DIA_EN_RVC_PWR_SUPPLY_SHORTCIRCUIT");
         break;

         case DIA_EN_RVC_PWR_SUPPLY_DEACTIVATED:
            (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0xFF));
            DIA_TR_INF("vOnRVCPowerSupplyStatus => DIA_EN_RVC_PWR_SUPPLY_DEACTIVATED");
         break;

         case DIA_EN_RVC_PWR_SUPPLY_DEACTIVATED_LOWVOLTAGE:
            (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0xFF));
            DIA_TR_INF("vOnRVCPowerSupplyStatus => DIA_EN_RVC_PWR_SUPPLY_DEACTIVATED_LOWVOLTAGE");
         break;

         case DIA_EN_RVC_PWR_SUPPLY_DEACTIVATED_HIGHVOLTAGE:
            (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0xFF));
            DIA_TR_INF("vOnRVCPowerSupplyStatus => DIA_EN_RVC_PWR_SUPPLY_DEACTIVATED_HIGHVOLTAGE");
         break;

         case DIA_EN_RVC_PWR_SUPPLY_SHORTTOGROUND:
            (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x05));
            DIA_TR_INF("vOnRVCPowerSupplyStatus => DIA_EN_RVC_PWR_SUPPLY_SHORTTOGROUND");
         break;

         case DIA_EN_RVC_PWR_SUPPLY_SHORTTOBATTERY:
            (void) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) 0x04));
            DIA_TR_INF("vOnRVCPowerSupplyStatus => DIA_EN_RVC_PWR_SUPPLY_SHORTTOBATTERY");
         break;

         default:
            DIA_TR_ERR("vOnRVCPowerSupplyStatus - ERR ON POWER SUPPLY STATUS(0x%02x)!!!", rvc_pwrSuppy);
         break;
      }

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_RVC_ControlLineStatus::vOnRVCPowerSupplyStatus SUCCESSFUL");
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_RVC_ControlLineStatus::vOnRVCPowerSupplyStatus FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }

}

