/*
 * dia_SrvHandler_PowerSupplyVoltageHistogram.h
 *
 *  Created on: 19.02.2018
 *      Author: hpe2hi
 */
//TTFis: DIA_REQ UDS 04 22 b1 13
#ifndef DIA_SRVHANDLER_POWERSUPPLY_VOLTAGE_HISTOGRAM_H_
#define DIA_SRVHANDLER_POWERSUPPLY_VOLTAGE_HISTOGRAM_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

class dia_SrvHandler_PowerSupplyVoltageHistogram
   : public dia_ServiceHandlerUDS,
     public dia_ISpmListenerImpl
{
      DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_PowerSupplyVoltageHistogram);


public:
   //! class constructor
      dia_SrvHandler_PowerSupplyVoltageHistogram ( void );

   /**
     * \brief    	handle the received request
     *
     *				Function receives the message via the oDiagMsgBuffer and send it to the SA.
     *				The SystemAdapter returns the Power Supply Voltage Histogram
     *
     * \param[in]	const std::vector<void*>&      not used here
     */
   virtual void vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ );

   /**
     * \brief    	status for the requested Power Supply Voltage State Counter Value
     *
     *				Function receives the message via its parameter and send it to the tester.
     *				It verifies the SA answer and send the power supply Histogram.
     *
     *
     */

   virtual void vOnGetPowerSupplyVoltageHistogram (const std::vector<dia_tSpmVoltageHistogramElement>* histogram );

protected:
   //! class destructor
   virtual ~dia_SrvHandler_PowerSupplyVoltageHistogram(void);

};


#endif /* DIA_SRVHANDLER_POWERSUPPLY_VOLTAGE_HISTOGRAM_H_ */
