/*
 * dia_SrvHandler_PowerSupply.h
 *
 *  Created on: 28.01.2014
 *      Author: kth4kor
 */
//TTFis: DIA_REQ UDS 04 22 b1 10
#ifndef DIA_SRVHANDLER_POWERSUPPLY_H_
#define DIA_SRVHANDLER_POWERSUPPLY_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif


class dia_SrvHandler_PowerSupply
   : public dia_ServiceHandlerUDS,
     public dia_ISpmListenerImpl
{
      DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_PowerSupply);


public:
   //! class constructor
      dia_SrvHandler_PowerSupply ( tVoid );

   /**
     * \brief    	handle the received request
     *
     *				Function receives the message via the oDiagMsgBuffer and send it to the SA.
     *				The SystemAdapter returns the Power Supply level
     *
     * \param[in]	const std::vector<tVoid*>&      not used here
     */
   virtual tVoid vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ );

   /**
     * \brief    	status for the requested Power Supply Value
     *
     *				Function receives the message via its parameter and send it to the tester.
     *				It verifies the SA answer and send the power supply level to the tester.
     *
     *
     */

   virtual tVoid vOnGetPowerSupply (tU16 voltage);

protected:
   //! class destructor
   virtual ~dia_SrvHandler_PowerSupply(tVoid);

};


#endif /* DIA_SRVHANDLER_POWERSUPPLY_H_ */
