/*
 * dia_SrvHandler_OpticaldriveLoaderstatus.h
 *
 *  Created on: 28.01.2014
 *      Author: fgl2hi
 */

#ifndef dia_SrvHandler_OPTICALDRIVELOADERSTATUS_H_
#define dia_SrvHandler_OPTICALDRIVELOADERSTATUS_H_

#ifndef __INCLUDED_DIA_INTERFACE_VD_MMGR_LISTENER__
#include "common/interfaces/dia_IVDMMGRListener.h"
#endif

class dia_SrvHandler_OpticaldriveLoaderstatus
   : public dia_ServiceHandlerUDS,
     public dia_IVDMMGRListenerImpl
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_OpticaldriveLoaderstatus);


public:
   //! class constructor
   dia_SrvHandler_OpticaldriveLoaderstatus ( void );

   /**
     * \brief     handle the received request
     *
     *            Function receives the message via the oDiagMsgBuffer and send it to the SA.
     *            The SystemAdapter returns the optical drive loader status.
     *
     * \param[in] void*     -
     * \param[in] void*     -
     */
   virtual void vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ );

   /**
     * \brief     status for the requested optical drive loader status
     *
     *            Function receives the message via its parameter and send it to the tester.
     *            It verifies the SA answer and send the expected value to the tester.
     *
     * \param[in] dia_eOpticalDriveLoaderStatus LoaderStatus
     */
   virtual void vOnOpticalDriveLoaderStatus( dia_eOpticalDriveLoaderStatus LoaderStatus );

protected:
   //! class destructor
   virtual ~dia_SrvHandler_OpticaldriveLoaderstatus(void);

};


#endif /* dia_SrvHandler_OPTICALDRIVELOADERSTATUS_H_ */
