/*
 * dia_SrvHandler_OpticaldriveLoaderstatus.cpp
 *
 *  Created on: 28.01.2014
 *      Author: fgl2hi
 */
// TTFis: DIA_REQ UDS 04 22 10 13

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#include "dia_SrvHandler_OpticaldriveLoaderstatus.h"

#ifndef __INCLUDED_DIA_INTERFACE_VD_MMGR_LISTENER__
#include "common/interfaces/dia_IVDMMGRListener.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 1

//-----------------------------------------------------------------------------

dia_SrvHandler_OpticaldriveLoaderstatus::dia_SrvHandler_OpticaldriveLoaderstatus ( void )
   : dia_ServiceHandlerUDS( "dia_SrvHandler_OpticaldriveLoaderstatus", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_OPTICAL_DRIVE_LOADER_STATUS )
{
   dia_tclFnctTrace trc( "dia_SrvHandler_OpticaldriveLoaderstatus::dia_SrvHandler_OpticaldriveLoaderstatus(void)" );
}

//-----------------------------------------------------------------------------

dia_SrvHandler_OpticaldriveLoaderstatus::~dia_SrvHandler_OpticaldriveLoaderstatus( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IVDMMGRListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR( "EXCEPTION CAUGHT: dia_SrvHandler_OpticaldriveLoaderstatus::~dia_SrvHandler_OpticaldriveLoaderstatus !!!" );
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void dia_SrvHandler_OpticaldriveLoaderstatus::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc( "dia_SrvHandler_OpticaldriveLoaderstatus::vProcessRequest" );

   tBool errorDetected = TRUE;
   dia_IVDMMGR* pVDMMGR = 0;
   if ( querySysAdapterInterface<dia_IVDMMGR>(&pVDMMGR) == DIA_SUCCESS )
   {
      if ( pVDMMGR )
      {
         (void) setSysAdapterListener<dia_IVDMMGRListener>(this);
         if ( pVDMMGR->getOpticalDriveLoaderStatus() == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      }
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IVDMMGRListener>(this);
      DIA_TR_ERR( "dia_SrvHandler_OpticaldriveLoaderstatus ---  SEND TO Media Manager Component failed!!!!" );
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

void dia_SrvHandler_OpticaldriveLoaderstatus::vOnOpticalDriveLoaderStatus( dia_eOpticalDriveLoaderStatus LoaderStatus )
{
   tBool bRetCorrect = FALSE;

   dia_tclFnctTrace trc( "dia_SrvHandler_OpticaldriveLoaderstatus::vOnOpticalDriveLoaderStatus" );
   DIA_TR_INF( "dia_SrvHandler_OpticaldriveLoaderstatus::vOnOpticalDriveLoaderStatus- LoaderStatus from SA = %d", LoaderStatus );

   (void) unsetSysAdapterListener<dia_IVDMMGRListener>(this);

   if( LoaderStatus < DIA_EN_MMGR_CD_LOADER_STATUS_COUNT )
   {
      tU8   u8MsgByte;
      bRetCorrect = TRUE;
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength( DATA_START + DATA_LENGTH );

      switch( LoaderStatus )
      {
         case DIA_EN_MMGR_CD_LOADER_STATUS_MEDIA_IN_SLOT:
         case DIA_EN_MMGR_CD_LOADER_STATUS_EJECT_IN_PROGRESS:
            u8MsgByte = 0x01;                                  // medium, in slot
            break;
         case DIA_EN_MMGR_CD_LOADER_STATUS_MEDIA_INSIDE:
            u8MsgByte = 0x02;                                  // emptymedium in drive
            break;
         case DIA_EN_MMGR_CD_LOADER_STATUS_NO_MEDIA_IN_DRIVE:
         case DIA_EN_MMGR_CD_LOADER_STATUS_UNKNOWN:            // no value planned for unknown status
         default:
            u8MsgByte = 0x00;                                  // empty; no medium in drive
            break;
      }
      DIA_TR_INF( "dia_SrvHandler_OpticaldriveLoaderstatus::vOnOpticalDriveLoaderStatus- LoaderStatus to client = %d", u8MsgByte );
      (void)oDiagMsgBuffer().vSetDataU8( DATA_START + 0, u8MsgByte );
   }  // if( LoaderStatus < DIA_EN_MMGR_CD_LOADER_STATUS_COUNT )

   if( bRetCorrect )
   {
      vResReadyAndQuit();
      DIA_TR_INF( "dia_SrvHandler_OpticaldriveLoaderstatus::vOnOpticalDriveLoaderStatus SUCCESSFUL" );
   }
   else
   {
      DIA_TR_INF( "dia_SrvHandler_OpticaldriveLoaderstatus::vOnOpticalDriveLoaderStatus FAIL" );
      // Sending back the Negative answer
      vSendNegativeResponse( DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT );
   }
}

