/********************************************************************************************
 * dia_SrvHandler_InputHdlTouchPanelStatus_Get.h
 *
 *  Created on: 04.03.2014
 *      Author: wgl2hi
 * ------------------------------------------------------------------------------------------
 * Date 			| Author			 | Modification
 * 27.11.15    		| ata7kor	  		 | Added a code change to resolve ticket AIVI-15132
 *
 * ------------------------------------------------------------------------------------------


*********************************************************************************************/
#ifndef __INCLUDED_DIA_SRVHANDLER_INPUT_HDL_TOUCH_PANEL_STATUS_GET_H_
#define __INCLUDED_DIA_SRVHANDLER_INPUT_HDL_TOUCH_PANEL_STATUS_GET_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_INPUTHANDLING_LISTENER__
#include "common/interfaces/dia_IInputHandlingListener.h"
#endif

class dia_SrvHandler_InputHdlTouchPanelStatus_Get
  : public dia_ServiceHandlerUDS
  , public dia_IInputHandlingListenerImpl
{
    DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_InputHdlTouchPanelStatus_Get);

  public:
    //! class constructor
    dia_SrvHandler_InputHdlTouchPanelStatus_Get(void);

    /**
     * \brief     handle the received request
     *
     *            Function receives the message via the oDiagMsgBuffer and send it to the SA.
     *
     * \param[in] const std::vector<void*>& vecArgs* - List with request information
     * \param[out]
     */
    virtual void vProcessRequest(const std::vector<tArgsType>& /*vecArgs*/);

    /**
     * \brief     status for the requested touch screen
     *
     *            Function receives the message via its parameter and send it to the tester.
     *            It verifies the SA answer and send the expected value to the tester.
     *
     * \param[in] eTouchInfo
     * \param[in] u16X
     * \param[in] u16Y
     * \param[in] u16DeltaX
     * \param[in] u16DeltaY
     */
    virtual void vOnTouchInfo(const tU16 u16X, const tU16 u16Y, const tU16 u16DeltaX, const tU16 u16DeltaY, const dia_eInputHandlingTouchInfo eTouchInfo);
    //! fn to handle error condition
    virtual void vOnTouchInfoError(void);

  protected:
    //! class destructor
    virtual ~dia_SrvHandler_InputHdlTouchPanelStatus_Get(void);

  private:
    tU8 getCmdsTouchStatusFromInternalTouchStatus(const dia_eInputHandlingTouchInfo internalTouchStatus);
    static const std::map<const dia_eInputHandlingTouchInfo, tU8> INTERNAL_2_CMDS_TOUCHSTATUS_MAPPING;
    static const tU8 CMDS_TOUCH_INFO_NOT_TOUCHED;
    static const tU8 CMDS_TOUCH_INFO_TOUCHED;
    static const tU8 CMDS_TOUCH_INFO_MOVE;
    static const tU8 CMDS_TOUCH_INFO_INVALID;
};

#endif /* __INCLUDED_DIA_SRVHANDLER_INPUT_HDL_TOUCH_PANEL_STATUS_GET_H_ */
