/*******************************************************************************************
 * dia_SrvHandler_InputHdlTouchPanelStatus_Get.cpp
 *
 *  Created on: 04.03.2014
 *      Author: wgl2hi

 * ------------------------------------------------------------------------------------------
 * Date 			| Author			 | Modification
 * 27.11.15    		| ata7kor	  		 | Added a code change to resolve ticket AIVI-15132
 *
 * ------------------------------------------------------------------------------------------

**********************************************************************************************/

#ifndef __INCLUDED_DIA_SRVHANDLER_INPUT_HDL_TOUCH_PANEL_STATUS_GET_H_
#include "common/services/uds/production/dia_SrvHandler_InputHdlTouchPanelStatus_Get.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_COMMON__
#include "common/framework/application/dia_defsCommon.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#define DIA_RESP_STATUS_START 3
#define DIA_RESP_COORDINATE_X_START 4
#define DIA_RESP_COORDINATE_Y_START 6
#define DIA_RESP_LENGTH 5

#define DIA_TOUCH_COORDINATE_NOT_TOUCHED ((tU8)0x00)

const tU8 dia_SrvHandler_InputHdlTouchPanelStatus_Get::CMDS_TOUCH_INFO_NOT_TOUCHED = 0x00;
const tU8 dia_SrvHandler_InputHdlTouchPanelStatus_Get::CMDS_TOUCH_INFO_TOUCHED     = 0x01;
const tU8 dia_SrvHandler_InputHdlTouchPanelStatus_Get::CMDS_TOUCH_INFO_MOVE        = 0x02;
const tU8 dia_SrvHandler_InputHdlTouchPanelStatus_Get::CMDS_TOUCH_INFO_INVALID     = 0x03;

const std::map<const dia_eInputHandlingTouchInfo, tU8> dia_SrvHandler_InputHdlTouchPanelStatus_Get::INTERNAL_2_CMDS_TOUCHSTATUS_MAPPING = {
    { DIA_EN_TOUCH_INFO_TOUCHED, CMDS_TOUCH_INFO_TOUCHED },
    { DIA_EN_TOUCH_INFO_NOT_TOUCHED, CMDS_TOUCH_INFO_NOT_TOUCHED },
    { DIA_EN_TOUCH_INFO_MOVE, CMDS_TOUCH_INFO_MOVE }
};

//-----------------------------------------------------------------------------

dia_SrvHandler_InputHdlTouchPanelStatus_Get::dia_SrvHandler_InputHdlTouchPanelStatus_Get(void)
  : dia_ServiceHandlerUDS("dia_SrvHandler_InputHdlTouchPanelStatus_Get",
                          DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
                          (tU16)DIA_C_U16_DID_RBCM_INPUT_HDL_TOUCH_PANEL_STATUS /*DID*/
    )
{
    dia_tclFnctTrace trc("dia_SrvHandler_InputHdlTouchPanelStatus_Get::dia_SrvHandler_InputHdlTouchPanelStatus_Get");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_InputHdlTouchPanelStatus_Get::~dia_SrvHandler_InputHdlTouchPanelStatus_Get(void)
{
    _BP_TRY_BEGIN { (void)unsetSysAdapterListener<dia_IInputHandlingListener>(this); }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_InputHdlTouchPanelStatus_Get::~dia_SrvHandler_InputHdlTouchPanelStatus_Get !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_InputHdlTouchPanelStatus_Get::vProcessRequest(const std::vector<tArgsType>& /*vecArgs*/)
{
    dia_tclFnctTrace trc("dia_SrvHandler_InputHdlTouchPanelStatus_Get::vProcessRequest");

    tBool errorDetected = TRUE;

    dia_IInputHandling* pInterface = NULL;
    if (querySysAdapterInterface<dia_IInputHandling>(&pInterface) == DIA_SUCCESS)
    {
        if (pInterface)
        {
            (void)setSysAdapterListener<dia_IInputHandlingListener>(this);
            if (pInterface->getTouchInfo() == DIA_SUCCESS)
            {
                errorDetected = FALSE;
                DIA_TR_INF("dia_SrvHandler_InputHdlTouchPanelStatus_Get - getTouchInfo SUCCESS!");
            }
            else
            {
                DIA_TR_INF("dia_SrvHandler_InputHdlTouchPanelStatus_Get - getTouchInfo FAILED!");
            }
        }
    }

    if (errorDetected)
    {
        (void)unsetSysAdapterListener<dia_IInputHandlingListener>(this);
        DIA_TR_ERR("dia_SrvHandler_InputHdlTouchPanelStatus_Get --- SEND TO dia_SAFeatureInputHandling FAILED!!!!");
        oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
        vResReadyAndQuit();
    }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_InputHdlTouchPanelStatus_Get::vOnTouchInfo(const tU16 u16X,
                                                          const tU16 u16Y,
                                                          const tU16 /*u16DeltaX*/,
                                                          const tU16 /*u16DeltaY*/,
                                                          const dia_eInputHandlingTouchInfo eTouchInfo)
{
    dia_tclFnctTrace trc("dia_SrvHandler_InputHdlTouchPanelStatus_Get::vOnTouchInfo");

    oDiagMsgBuffer().vSetPosResp();
    oDiagMsgBuffer().vSetDataLength(DIA_RESP_STATUS_START + DIA_RESP_LENGTH);

    for (tU8 u8Index = 0; u8Index < DIA_RESP_LENGTH; u8Index++)
    {
        (void)oDiagMsgBuffer().vSetDataU8(tU16(DIA_RESP_STATUS_START + u8Index), 0x00);
    }

    // status
    (void)oDiagMsgBuffer().vSetDataU8(DIA_RESP_STATUS_START, getCmdsTouchStatusFromInternalTouchStatus(eTouchInfo));

    if (eTouchInfo == DIA_EN_TOUCH_INFO_TOUCHED)
    {
        // x
        (void)oDiagMsgBuffer().vSetDataU8(DIA_RESP_COORDINATE_X_START, (tU8)(u16X >> 8));
        (void)oDiagMsgBuffer().vSetDataU8(DIA_RESP_COORDINATE_X_START + 1, (tU8)u16X);
        // y
        (void)oDiagMsgBuffer().vSetDataU8(DIA_RESP_COORDINATE_Y_START, (tU8)(u16Y >> 8));
        (void)oDiagMsgBuffer().vSetDataU8(DIA_RESP_COORDINATE_Y_START + 1, (tU8)u16Y);
    }
    else
    {
        // x
        (void)oDiagMsgBuffer().vSetDataU8(DIA_RESP_COORDINATE_X_START, DIA_TOUCH_COORDINATE_NOT_TOUCHED);
        (void)oDiagMsgBuffer().vSetDataU8(DIA_RESP_COORDINATE_X_START + 1, DIA_TOUCH_COORDINATE_NOT_TOUCHED);
        // y
        (void)oDiagMsgBuffer().vSetDataU8(DIA_RESP_COORDINATE_Y_START, DIA_TOUCH_COORDINATE_NOT_TOUCHED);
        (void)oDiagMsgBuffer().vSetDataU8(DIA_RESP_COORDINATE_Y_START + 1, DIA_TOUCH_COORDINATE_NOT_TOUCHED);
    }

    (void)unsetSysAdapterListener<dia_IInputHandlingListener>(this);
    vResReadyAndQuit();
}
//--------------------------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    vOnTouchInfoError
*
* DESCRIPTION: Handle the error and unset the InputHandlingListener
*
* PARAMETER:    none
                none
*
* RETURNVALUE: none
*              none
*
******************************************************************************/
void
dia_SrvHandler_InputHdlTouchPanelStatus_Get::vOnTouchInfoError(void)
{
    (void)unsetSysAdapterListener<dia_IInputHandlingListener>(this);
    DIA_TR_ERR(" ---  SEND TO KEYBOARD SERVER FAILED!!!!");
    vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
}

tU8
dia_SrvHandler_InputHdlTouchPanelStatus_Get::getCmdsTouchStatusFromInternalTouchStatus(const dia_eInputHandlingTouchInfo internalTouchStatus)
{
    tU8 cmdsTouchStatus = CMDS_TOUCH_INFO_INVALID;
    auto it             = INTERNAL_2_CMDS_TOUCHSTATUS_MAPPING.find(internalTouchStatus);
    if (it != INTERNAL_2_CMDS_TOUCHSTATUS_MAPPING.end())
    {
        cmdsTouchStatus = it->second;
    }
    return cmdsTouchStatus;
}
