/*
 * dia_SrvHandler_InputHdlEncoder1CounterValue_Get.h
 *
 *  Created on: 05.03.2014
 *      Author: wgl2hi
 */

#ifndef __INCLUDED_DIA_SRVHANDLER_INPUT_HDL_ENCODER1_COUNTER_VALUE_GET_H_
#define __INCLUDED_DIA_SRVHANDLER_INPUT_HDL_ENCODER1_COUNTER_VALUE_GET_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_INPUTHANDLING_LISTENER__
#include "common/interfaces/dia_IInputHandlingListener.h"
#endif

class dia_SrvHandler_InputHdlEncoder1CounterValue_Get
   : public dia_ServiceHandlerUDS,
     public dia_IInputHandlingListenerImpl
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR( dia_SrvHandler_InputHdlEncoder1CounterValue_Get );

public:
   //! class constructor
   dia_SrvHandler_InputHdlEncoder1CounterValue_Get( void );

   /**
     * \brief     handle the received request
     *
     *            Function receives the message via the oDiagMsgBuffer and send it to the SA.
     *
     * \param[in] const std::vector<void*>& vecArgs* - List with request information
     * \param[out]
     */
   virtual void vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ );

   /**
     * \brief     the requested encoder status of operating unit
     *
     *            Function receives the message via its parameter and send it to the tester.
     *            It verifies the SA answer and send the expected value to the tester.
     *
     * \param[in] vecEncoderStatus
     */
      virtual void vOnEncoderStatus ( const std::vector<tU8> vecEncoderStatus );

protected:
   //! class destructor
   virtual ~dia_SrvHandler_InputHdlEncoder1CounterValue_Get(void);
};


#endif /* __INCLUDED_DIA_SRVHANDLER_INPUT_HDL_ENCODER1_COUNTER_VALUE_GET_H_ */
