/*
 * dia_SrvHandler_InputHdlEncoder1CounterValue_Get.cpp
 *
 *  Created on: 05.03.2014
 *      Author: wgl2hi
 */

#ifndef __INCLUDED_DIA_SRVHANDLER_INPUT_HDL_ENCODER1_COUNTER_VALUE_GET_H_
#include "common/services/uds/production/dia_SrvHandler_InputHdlEncoder1CounterValue_Get.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_COMMON__
#include "common/framework/application/dia_defsCommon.h"
#endif

#define DATA_START_ENCODER      3
#define DATA_LENGTH_ENCODER     1

//-----------------------------------------------------------------------------

dia_SrvHandler_InputHdlEncoder1CounterValue_Get::dia_SrvHandler_InputHdlEncoder1CounterValue_Get ( void )
    : dia_ServiceHandlerUDS( "dia_SrvHandler_InputHdlEncoder1CounterValue_Get",
                            DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
                      (tU16) DIA_C_U16_DID_RBCM_INPUT_HDL_ENCODER_1_COUNTER_VALUE /*DID*/
                            )
{
   dia_tclFnctTrace trc("dia_SrvHandler_InputHdlEncoder1CounterValue_Get::dia_SrvHandler_InputHdlEncoder1CounterValue_Get(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_InputHdlEncoder1CounterValue_Get::~dia_SrvHandler_InputHdlEncoder1CounterValue_Get( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IInputHandlingListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_InputHdlEncoder1CounterValue_Get::~dia_SrvHandler_InputHdlEncoder1CounterValue_Get !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_InputHdlEncoder1CounterValue_Get::vProcessRequest( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_InputHdlEncoder1CounterValue_Get::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IInputHandling* pInterface = NULL;
   if( querySysAdapterInterface<dia_IInputHandling>(&pInterface) == DIA_SUCCESS )
   {
      if( pInterface )
      {
         (void)setSysAdapterListener<dia_IInputHandlingListener>(this);
         if( pInterface->getEncoderStatus () == DIA_SUCCESS )
         {
         DIA_TR_INF( "dia_SrvHandler_InputHdlEncoder1CounterValue_Get - getEncoderStatus SUCCESS!" );
            errorDetected = FALSE;
         }
         else
         {
            DIA_TR_INF( "dia_SrvHandler_InputHdlEncoder1CounterValue_Get - getEncoderStatus FAILED!" );
         }
      }
   }

   if( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IInputHandlingListener>(this);
      DIA_TR_ERR( "dia_SrvHandler_InputHdlEncoder1CounterValue_Get - SEND TO dia_SAFeatureInputHandling FAILED!!!!" );
      oDiagMsgBuffer().vSetNegResp( DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT );
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_InputHdlEncoder1CounterValue_Get::vOnEncoderStatus ( const std::vector<tU8> vecEncoderStatus )
{
   dia_tclFnctTrace trc( "dia_SrvHandler_InputHdlEncoder1CounterValue_Get::vOnEncoderStatus" );

   size_t vecSize = vecEncoderStatus.size();
   DIA_TR_INF( "dia_SrvHandler_InputHdlEncoder1CounterValue_Get::vOnEncoderStatus - size of encoders = %zu",vecSize );

   if (vecSize > 0)
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START_ENCODER + DATA_LENGTH_ENCODER);
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START_ENCODER, vecEncoderStatus[0]);
   }
   else
   {
     DIA_TR_ERR( "dia_SrvHandler_InputHdlEncoder1CounterValue_Get::vOnEncoderStatus - no encoder 1 available" );
      oDiagMsgBuffer().vSetNegResp( DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT );
   }

   (void) unsetSysAdapterListener<dia_IInputHandlingListener>(this);
   vResReadyAndQuit();
}
