/*
 * dia_SrvHandler_HistoryWakeup.cpp
 *
 *  Created on: 12.03.2013
 *      Author: shw2abt
 */
// TTFis: DIA_REQ UDS 04 22 10 31
#include "common/services/uds/production/dia_SrvHandler_HistoryWakeup.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3
#define WAKEUP_HISTORY_ELEMENT_SIZE       11    /* bytes */
#define WAKEUP_HISTORY_NUMBER_OF_ELEMENT  10
#define WAKEUP_HISTORY_ELEMENTS_LIMIT ((WAKEUP_HISTORY_ELEMENT_SIZE)*(WAKEUP_HISTORY_NUMBER_OF_ELEMENT))

//-----------------------------------------------------------------------------

dia_SrvHandler_HistoryWakeup::dia_SrvHandler_HistoryWakeup(void) :
      dia_ServiceHandlerUDS("dia_SrvHandler_HistoryWakeup", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_RBCM_SPM_HISTORY_WAKEUP /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_HistoryWakeup::dia_SrvHandler_HistoryWakeup(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_HistoryWakeup::~dia_SrvHandler_HistoryWakeup(void)
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_HistoryWakeup::~dia_SrvHandler_HistoryWakeup !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void dia_SrvHandler_HistoryWakeup::vProcessRequest(const std::vector<tArgsType>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_HistoryWakeup::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISpm* pSpm = 0;
   if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
      if (pSpm) {
         (void) setSysAdapterListener<dia_ISpmListener>(this);
         if (pSpm->getWakeUpHistory() == DIA_SUCCESS) {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR("dia_SrvHandler_HistoryWakeup ---  SEND TO SPM SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

void dia_SrvHandler_HistoryWakeup::vOnGetWakeUpHistory(const std::vector<tU8>* wakeupElements)
{
   dia_tclFnctTrace trc("dia_SrvHandler_HistoryWakeup::vOnGetWakeUpHistory");

   oDiagMsgBuffer().vSetPosResp();
   // Sending back the positive answer
   oDiagMsgBuffer().vSetDataLength(DATA_START + WAKEUP_HISTORY_ELEMENTS_LIMIT);

   for (tU16 i = 0; i < WAKEUP_HISTORY_ELEMENTS_LIMIT; i++)
   {
      if (i < ((tU16) wakeupElements->size()))
      {
         (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START + i), wakeupElements->at(i));
      }
      else
      {
         (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START + i), 0x00);
      }
   }

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   vResReadyAndQuit();
}
