/*
 * dia_SrvHandler_HistoryState.h
 *
 *  Created on: 12.03.2013
 *      Author: shw2abt
 */

#ifndef DIA_SRVHANDLER_HISTORYSTATE_H_
#define DIA_SRVHANDLER_HISTORYSTATE_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

class dia_SrvHandler_HistoryState
   : public dia_ServiceHandlerUDS,
     public dia_ISpmListenerImpl
{
      DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_HistoryState);


public:
   //! class constructor
      dia_SrvHandler_HistoryState ( void );

   /**
     * \brief  handle the received request
     *         Function receives the message via the oDiagMsgBuffer and send it to the SA.
     *         The SystemAdapter returns the reset history.
     */
   virtual void vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ );

   /**
     * \brief    	status for the requested state history
     *            Function receives the message via its parameter and send it to the tester.
     *            It verifies the SA answer and send the state history list to the tester.
     * \param[in]	const std::vector<tU8>* stateElements
     */
   virtual void vOnGetStateHistory ( const std::vector<tU8>* stateElements );

protected:
   //! class destructor
   virtual ~dia_SrvHandler_HistoryState(void);

};


#endif /* DIA_SRVHANDLER_HISTORYSTATE_H_ */
