/*
 * dia_SrvHandler_HistoryState.cpp
 *
 *  Created on: 12.03.2013
 *      Author: shw2abt
 */
// TTFis: DIA_REQ UDS 04 22 10 32
#include "common/services/uds/production/dia_SrvHandler_HistoryState.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3
#define STATE_HISTORY_ELEMENT_SIZE        41 /* bytes */
#define STATE_HISTORY_NUMBER_OF_ELEMENT   60
#define STATE_HISTORY_ELEMENTS_LIMIT ((STATE_HISTORY_ELEMENT_SIZE)*(STATE_HISTORY_NUMBER_OF_ELEMENT))

//-----------------------------------------------------------------------------

dia_SrvHandler_HistoryState::dia_SrvHandler_HistoryState(void) :
      dia_ServiceHandlerUDS("dia_SrvHandler_HistoryState", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_RBCM_SPM_HISTORY_STATE /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_HistoryState::dia_SrvHandler_HistoryState(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_HistoryState::~dia_SrvHandler_HistoryState(void)
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_HistoryState::~dia_SrvHandler_HistoryState !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }

   _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void dia_SrvHandler_HistoryState::vProcessRequest(const std::vector<tArgsType>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_HistoryState::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISpm* pSpm = 0;
   if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS)
   {
      if (pSpm) {
         (void) setSysAdapterListener<dia_ISpmListener>(this);
         if (pSpm->getStateHistory() == DIA_SUCCESS) {
            errorDetected = FALSE;
         }
      }
      else
      {
         DIA_TR_ERR("dia_SrvHandler_HistoryState::vProcessRequest pSpm NULL");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SrvHandler_HistoryState::vProcessRequest querySysAdapterInterface FAILED");
   }

   if (errorDetected) {
      (void) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR("dia_SrvHandler_HistoryState ---  SEND TO SPM SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

void dia_SrvHandler_HistoryState::vOnGetStateHistory(const std::vector<tU8>* stateElements)
{
   dia_tclFnctTrace trc("dia_SrvHandler_HistoryState::vOnGetStateHistory");

   oDiagMsgBuffer().vSetPosResp();
   // Sending back the positive answer
   oDiagMsgBuffer().vSetDataLength(DATA_START + STATE_HISTORY_ELEMENTS_LIMIT);

   for (tU16 i = 0; i < STATE_HISTORY_ELEMENTS_LIMIT; i++)
   {
      if(i < ((tU16) stateElements->size()))
      {
         (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START + i), stateElements->at(i));
      }
      else
      {
         (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START + i), 0);
      }
   }

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   vResReadyAndQuit();
}
