/*
 * dia_SrvHandler_HistoryReset.cpp
 *
 *  Created on: 12.03.2013
 *      Author: shw2abt
 */
// TTFis: DIA_REQ UDS 04 22 10 30
#include "common/services/uds/production/dia_SrvHandler_HistoryReset.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3
//#define DATA_LENGTH 3
#define RESET_HISTORY_ELEMENT_SIZE 8
#define RESET_HISTORY_ELEMENTS_LENGTH 20
#define RESET_HISTORY_ELEMENTS_LIMIT ((RESET_HISTORY_ELEMENT_SIZE)*(RESET_HISTORY_ELEMENTS_LENGTH))

//-----------------------------------------------------------------------------

dia_SrvHandler_HistoryReset::dia_SrvHandler_HistoryReset(tVoid) :
      dia_ServiceHandlerUDS("dia_SrvHandler_HistoryReset", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_RBCM_SPM_HISTORY_RESET /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_HistoryReset::dia_SrvHandler_HistoryReset(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_HistoryReset::~dia_SrvHandler_HistoryReset(tVoid)
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_HistoryReset::~dia_SrvHandler_HistoryReset !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
_BP_CATCH_END}

//-------------------------------------------------------------------------------

tVoid dia_SrvHandler_HistoryReset::vProcessRequest(const std::vector<tArgsType>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_HistoryReset::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_ISpm* pSpm = 0;
   if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
      if (pSpm) {
         (tVoid) setSysAdapterListener<dia_ISpmListener>(this);
         if (pSpm->getResetHistory() == DIA_SUCCESS) {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR("dia_SrvHandler_HistoryReset ---  SEND TO SPM SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

tVoid dia_SrvHandler_HistoryReset::vOnGetResetHistory(const std::vector<tU8>* resetElements)
{
   dia_tclFnctTrace trc("dia_SrvHandler_HistoryReset::dia_SrvHandler_HistoryReset");

   oDiagMsgBuffer().vSetPosResp();
   // Sending back the positive answer
   oDiagMsgBuffer().vSetDataLength(DATA_START + RESET_HISTORY_ELEMENTS_LIMIT);

   for (tU16 i = 0; i < RESET_HISTORY_ELEMENTS_LIMIT; i++)
   {
      if(i < ((tU16) (resetElements->size()-1)))
      {
         (tVoid) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START + i), resetElements->at(i+1));
      }
      else
      {
         (tVoid) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START + i), 0);
      }
   }

   (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
   vResReadyAndQuit();
   DIA_TR_INF("dia_SrvHandler_HistoryReset::dia_SrvHandler_HistoryReset SUCCESSFUL");
}
