/*
 * dia_SrvHandler_GetPlayedTrack.cpp
 *
 *  Created on: 08.08.2012
 *      Author: shw2abt
 */
// TTFis:\> DIA_REQ UDS 04 22 61 21

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#include "dia_SrvHandler_GetPlayedTrack.h"

#define DATA_START  3
#define DATA_LENGTH 2

//-----------------------------------------------------------------------------

dia_SrvHandler_GetPlayedTrack::dia_SrvHandler_GetPlayedTrack ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_GetPlayedTrack",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16)DIA_C_U16_DID_RBCM_CDDA_PLAYED_TRACK /*DID*/)
{
   dia_tclFnctTrace trc("dia_SrvHandler_GetPlayedTrack::dia_SrvHandler_GetPlayedTrack(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_GetPlayedTrack::~dia_SrvHandler_GetPlayedTrack ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_IMediaAudioCdListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_GetPlayedTrack::~dia_SrvHandler_GetPlayedTrack !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_GetPlayedTrack::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GetPlayedTrack::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IMediaAudioCd* pInterface = 0;
   if ( querySysAdapterInterface<dia_IMediaAudioCd>(&pInterface) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandler_GetPlayedTrack::vProcessRequest - querySysAdapterInterface OK.");
      if ( pInterface )
      {
         DIA_TR_INF("dia_SrvHandler_GetPlayedTrack::vProcessRequest - pInterface OK.");
         (tVoid) setSysAdapterListener<dia_IMediaAudioCdListener>(this);
         if ( pInterface->requestTrackNumber() == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_GetPlayedTrack::vProcessRequest - pInterface->requestTrackNumber() OK.");
            errorDetected = FALSE;
         }
      }
   } else {
      DIA_TR_INF("dia_SrvHandler_GetPlayedTrack::vProcessRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IMediaAudioCdListener>(this);
      DIA_TR_ERR(" ---  SEND TO AUDIO SERVER FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_GetPlayedTrack::vOnTrackNumber ( tU16 playedTrack )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GetPlayedTrack::vOnTrackNumber");

   (tVoid) unsetSysAdapterListener<dia_IMediaAudioCdListener>(this);

   // no way to check playedTrack number in a meaningful way
   if ( playedTrack != 0xFFFF )
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);

      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 0, ((tU8) (playedTrack >> 8)));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START + 1, ((tU8) (playedTrack)));

      vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_GetPlayedTrack::vOnTrackNumber SUCCESSFUL");
   }
   else {
      DIA_TR_INF("dia_SrvHandler_GetPlayedTrack::vOnTrackNumber FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
