/*!
 * \file       dia_SrvHandler_GetActiveALDlevel.cpp
 *
 * \brief      Read Activate Security ALD level
 *
 * \details    Class dia_SrvHandler_GetActiveALDlevel gets the Activated ALD Security Level.
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreSecurity
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_SRVHANDLER_GETACTIVEALDLEVEL_H__
#define __INCLUDED_DIA_SRVHANDLER_GETACTIVEALDLEVEL_H__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef  __INCLUDED_DIA_INTERFACE_AUTHORIZATIONLEVEL__
#include "common/interfaces/dia_IAuthorizationLevel.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUTHORIZATIONLEVEL_LISTENER__
#include "common/interfaces/dia_IAuthorizationLevelListener.h"
#endif

class dia_SrvHandler_GetActiveALDlevel
   : public dia_ServiceHandlerUDS,
     public dia_IAuthorizationLevelListenerImpl
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_GetActiveALDlevel);

public:
   //! class constructor
    dia_SrvHandler_GetActiveALDlevel (tVoid );

   //! class destructor
   virtual ~dia_SrvHandler_GetActiveALDlevel ( void );

   //! handle the received request
   virtual void vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ );

   //! default implementation for timeout notifications (initiates negative response 0x22)
   virtual void vOnTimeout ( void );
   //! currently active security level
   virtual void vOnLevel ( tU16 levelID ) ;

};

#endif /* __INCLUDED_DIA_SRVHANDLER_GETACTIVEALDLEVEL_H__ */
