/*!
 * \file       dia_SrvHandler_GetActiveALDlevel.cpp
 *
 * \brief      Read Activate Security ALD level
 *
 * \details    Class dia_SrvHandler_GetActiveALDlevel gets the Activated ALD Security Level.
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreSecurity
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia
 *
 */
// TTFis:\> DIA_REQ UDS 03 22 80 01

#ifndef __INCLUDED_DIA_SRVHANDLER_GETACTIVEALDLEVEL_H__
#include "dia_SrvHandler_GetActiveALDlevel.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include "common/depricated/dia_defsUds.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3
#define DATA_LENGTH 1

//-----------------------------------------------------------------------------

 dia_SrvHandler_GetActiveALDlevel::dia_SrvHandler_GetActiveALDlevel ( tVoid )
    : dia_ServiceHandlerUDS("dia_SrvHandler_GetActiveALDlevel",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_ACTIVE_ALD_LEVEL)
{
   dia_tclFnctTrace trc("dia_SrvHandler_GetActiveALDlevel::dia_SrvHandler_GetActiveALDlevel(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_GetActiveALDlevel::~dia_SrvHandler_GetActiveALDlevel ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IAuthorizationLevelListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_GetActiveALDlevel::~dia_SrvHandler_GetActiveALDlevel !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_SrvHandler_GetActiveALDlevel::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GetActiveALDlevel::vProcessRequest");

   for ( tU16 i = 0; i < oDiagMsgBuffer().u16GetDataLength(); i++)
   {
      DIA_TR_INF("dia_SrvHandler_GetActiveALDlevel::input-buffer[%d] 0x%02x", i, oDiagMsgBuffer().u8GetData(i) );
   }

   if( oDiagMsgBuffer().u16GetDataLength() != (DATA_START+DATA_LENGTH) )
   {
      DIA_TR_ERR("dia_SrvHandler_GetActiveALDlevel --- Incorrect Message Length Passed(Length = %d)", oDiagMsgBuffer().u16GetDataLength());
      vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
   }
   else
   {
	   dia_IAuthorizationLevel* pInterface = 0;
      if ( (querySysAdapterInterface<dia_IAuthorizationLevel>(&pInterface) == DIA_SUCCESS) && pInterface )
      {
         (void) setSysAdapterListener<dia_IAuthorizationLevelListener>(this);
         if ( pInterface->getActiveLevel() == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SrvHandler_GetActiveALDlevel - getActiveLevel() returned DIA_SUCCESS.");
            //! Wait for the response and send a response back to tester.
         }
         else
         {
            (void) unsetSysAdapterListener<dia_IAuthorizationLevelListener>(this);
            DIA_TR_ERR("dia_SrvHandler_GetActiveALDlevel --- Send to Security Component FAILED!");
            vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
         }
      }
      else
      {
         DIA_TR_ERR("dia_SrvHandler_GetActiveALDlevel - querySysAdapterInterface failed.");
         vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      }
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandler_GetActiveALDlevel::vOnTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_SrvHandler_GetActiveALDlevel::vOnTimeout");
   (void) unsetSysAdapterListener<dia_IAuthorizationLevelListener>(this);

   dia_ServiceHandlerUDS::vOnTimeout();
}


void dia_SrvHandler_GetActiveALDlevel::vOnLevel ( tU16 levelID )
{
	 dia_tclFnctTrace trc("dia_SrvHandler_GetActiveALDlevel::vOnLevel");
	   (void) unsetSysAdapterListener<dia_IAuthorizationLevelListener>(this);

	   // Sending back the positive answer
	   oDiagMsgBuffer().vSetPosResp();
	   oDiagMsgBuffer().vSetDataLength(DATA_START + (tU16) DATA_LENGTH);
	   (void) oDiagMsgBuffer().vSetDataU8(DATA_START,(tU8)levelID);

	vResReadyAndQuit();
}
