/*
 * dia_SrvHandler_GNSSSatellitesSignalQuality_Get.cpp
 *
 *  Created on: 24.07.2012
 *      Author: sta8hi
 *
 * TTFis: DIA_REQ UDS 03 22 63 05
 * ------------------------------------------------------------------------------------
 * Date 			| Author			 | Modification
 * 06.08.14    		| nce5kor	  		 | Added a code change to fix negative response issue in feature GNSS_SatellitesSignalQuality
 * 25.07.14    		| nce5kor	  		 | Added a small code change to fix the issue for GNSS_SatellitesSignalQuality
 * ------------------------------------------------------------------------------------
 */
// TTFis: DIA_REQ UDS 03 22 63 05

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#include "dia_SrvHandler_GNSSSatellitesSignalQuality_Get.h"

#ifndef __INCLUDED_DIA_INTERFACE_GNSS_LISTENER__
#include "common/interfaces/dia_IGNSSListener.h"
#endif

#define DATA_START (1/*sizeof(SID)*/ + mDIDLen)
#define DATA_LEN   (32 * 3)


//-----------------------------------------------------------------------------

dia_SrvHandler_GNSSSatellitesSignalQuality_Get::dia_SrvHandler_GNSSSatellitesSignalQuality_Get ()
    : dia_ServiceHandlerUDS("dia_SrvHandler_GNSSSatellitesSignalQuality_Get",
          DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
          DIA_C_U16_DID_GNSS_SATELLITE_SIG_QUALITY)

{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSSatellitesSignalQuality_Get::dia_SrvHandler_GNSSSatellitesSignalQuality_Get");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_GNSSSatellitesSignalQuality_Get::~dia_SrvHandler_GNSSSatellitesSignalQuality_Get ()
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IGNSSListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_GNSSSatellitesSignalQuality_Get::~dia_SrvHandler_GNSSSatellitesSignalQuality_Get !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_GNSSSatellitesSignalQuality_Get::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSSatellitesSignalQuality_Get::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IGNSS* pGNSS = 0;
   if ( querySysAdapterInterface<dia_IGNSS>(&pGNSS) == DIA_SUCCESS )
   {
      if ( pGNSS )
      {
         (void) setSysAdapterListener<dia_IGNSSListener>(this);
         if ( pGNSS->getGNSSData() == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      }
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IGNSSListener>(this);
      DIA_TR_ERR(" ---  SEND TO GNSS_Sensor Componente faild!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_GNSSSatellitesSignalQuality_Get::vOnGNSSSatellitesSignalQuality ( const std::vector<dia_tGNSSSatellitesSignalQuality>& quality )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSSatellitesSignalQuality_Get::vOnGNSSSatellitesSignalQuality");

   (void) unsetSysAdapterListener<dia_IGNSSListener>(this);

   if ( !(quality.empty()) )
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(static_cast<tU16>(DATA_START + DATA_LEN));

       std::vector<dia_tGNSSSatellitesSignalQuality>::const_iterator it = quality.begin();
       tU32 i;
       for ( i = 0 ; (it != quality.end()) && (i < DATA_LEN); ++it, i += 3 )
       {
		   if(it->m_u8SignalQuality != 0)
		   {
          (void) oDiagMsgBuffer().vSetDataU8((tU16) (DATA_START+i+0),U16_BYTE1(it->m_u16SatellitesId));
          (void) oDiagMsgBuffer().vSetDataU8((tU16) (DATA_START+i+1),U16_BYTE2(it->m_u16SatellitesId));
          (void) oDiagMsgBuffer().vSetDataU8((tU16) (DATA_START+i+2),it->m_u8SignalQuality);
		   }
		   else
		   {
			   (void) oDiagMsgBuffer().vSetDataU8((tU16) (DATA_START+i+0), 0);
			   (void) oDiagMsgBuffer().vSetDataU8((tU16) (DATA_START+i+1), 0);
			   (void) oDiagMsgBuffer().vSetDataU8((tU16) (DATA_START+i+2), 0);
		   }

          DIA_TR_INF("m_u16SatellitesId = %d",it->m_u16SatellitesId);
          DIA_TR_INF("m_u8SignalQuality = %d",it->m_u8SignalQuality);
       }

       for ( ; i < DATA_LEN; i += 3 )
       {
          (void) oDiagMsgBuffer().vSetDataU8((tU16) (DATA_START+i+0), 0);
          (void) oDiagMsgBuffer().vSetDataU8((tU16) (DATA_START+i+1), 0);
          (void) oDiagMsgBuffer().vSetDataU8((tU16) (DATA_START+i+2), 0);
       }

       vResReadyAndQuit();
       DIA_TR_INF("dia_SrvHandler_GNSSSatellitesSignalQuality_Get::vOnGNSSSatellitesSignalQuality SUCCESSFUL");
   }
   else
   {
	   oDiagMsgBuffer().vSetPosResp();
       oDiagMsgBuffer().vSetDataLength(static_cast<tU16>(DATA_START + DATA_LEN));

	   tU32 i;
	   for ( i = 0 ; i < DATA_LEN; i += 3 )
       {
          (void) oDiagMsgBuffer().vSetDataU8((tU16) (DATA_START+i+0), 0);
          (void) oDiagMsgBuffer().vSetDataU8((tU16) (DATA_START+i+1), 0);
          (void) oDiagMsgBuffer().vSetDataU8((tU16) (DATA_START+i+2), 0);
       }
	   vResReadyAndQuit();
      DIA_TR_INF("dia_SrvHandler_GNSSSatellitesSignalQuality_Get::vOnGNSSSatellitesSignalQuality LIST EMPTY");
      // Sending back the Negative answer
      //vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

