/*
 * dia_SrvHandler_GNSSReceiverStatus_Get.cpp
 *
 *  Created on: 24.07.2012
 *      Author: sta8hi
 */
// TTFis: DIA_REQ UDS 03 22 63 06

#include "dia_SrvHandler_GNSSReceiverStatus_Get.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DATA_START 3


//-----------------------------------------------------------------------------

dia_SrvHandler_GNSSReceiverStatus_Get::dia_SrvHandler_GNSSReceiverStatus_Get ( )
    : dia_ServiceHandlerUDS("dia_SrvHandler_GNSSReceiverStatus_Get",
          DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
          DIA_C_U16_DID_RBCM_GNSS_RECEIVER_STATUS)

{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSReceiverStatus_Get::dia_SrvHandler_GNSSReceiverStatus_Get(tVoid)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_GNSSReceiverStatus_Get::~dia_SrvHandler_GNSSReceiverStatus_Get( )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IGNSSListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_GNSSReceiverStatus_Get::~dia_SrvHandler_GNSSReceiverStatus_Get !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandler_GNSSReceiverStatus_Get::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSReceiverStatus_Get::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IGNSS* pGNSS = 0;
   if ( querySysAdapterInterface<dia_IGNSS>(&pGNSS) == DIA_SUCCESS )
   {
      if ( pGNSS )
      {
         (void) setSysAdapterListener<dia_IGNSSListener>(this);
         if ( pGNSS->getGNSSData() == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      }
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IGNSSListener>(this);
      DIA_TR_ERR("dia_SrvHandler_GNSSReceiverStatus_Get ---  SEND TO GNSS_Sensor Component failed!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandler_GNSSReceiverStatus_Get::vOnGNSSReceiverStatus  ( const dia_tGNSSReceiverState& info )
{
   dia_tclFnctTrace trc("dia_SrvHandler_GNSSReceiverStatus_Get::vOnGNSSReceiverStatus");

   (void) unsetSysAdapterListener<dia_IGNSSListener>(this);

   if(info.m_u8SatellitesVisible<33 && info.m_u8SatellitesUsed<33 && info.m_u8SatellitesReceived<33 && info.m_u8SatellitesHealthy<33)
   {
      DIA_TR_INF("m_u8FixStatus          = %d / 0x%02x .",info.m_u8FixStatus, info.m_u8FixStatus);
      DIA_TR_INF("m_u8SatellitesReceived = %d / 0x%02x .", info.m_u8SatellitesReceived, info.m_u8SatellitesReceived);
      DIA_TR_INF("m_u8SatellitesUsed     = %d / 0x%02x .", info.m_u8SatellitesUsed, info.m_u8SatellitesUsed);
      DIA_TR_INF("m_u8SatellitesHealthy  = %d / 0x%02x .", info.m_u8SatellitesHealthy, info.m_u8SatellitesHealthy);
      DIA_TR_INF("m_u8SatellitesVisible  = %d / 0x%02x .", info.m_u8SatellitesVisible, info.m_u8SatellitesVisible);
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START+ 5);

      (void) oDiagMsgBuffer().vSetDataU8(DATA_START+0,(tU8) info.m_u8FixStatus);
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START+1,(tU8) info.m_u8SatellitesReceived);
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START+2,(tU8) info.m_u8SatellitesUsed);
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START+3,(tU8) info.m_u8SatellitesHealthy);
      (void) oDiagMsgBuffer().vSetDataU8(DATA_START+4,(tU8) info.m_u8SatellitesVisible);

       vResReadyAndQuit();
       DIA_TR_INF("dia_SrvHandler_GNSSReceiverStatus_Get::vOnGNSSReceiverStatus SUCCESSFUL");
   }
   else
   {
      DIA_TR_INF("dia_SrvHandler_GNSSReceiverStatus_Get::vOnGNSSReceiverStatus FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
