/*
 * dia_SrvHandler_CustomerAndBuildSWVersion_Write.cpp
 *
 *  Created on:
 *      Author:
 */

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_FILE_DIR__
#include <common/framework/application/dia_FileDir.h>
#endif

#ifndef __INCLUDED_DIA_FILE__
#include "common/framework/application/dia_File.h"
#endif

//needed by sync
#include <unistd.h>     //lint !e451 !e537 repeatedly included header file without standard include guard

#include "dia_SrvHandler_CustomerAndBuildSWVersion_Write.h"

#define DATA_START             3

static tCString DIR_NAME = "/var/opt/bosch/persistent/registry" ;
static tCString FILE_NAME = "/var/opt/bosch/persistent/registry/customerversion_reg.cfg" ;

#ifdef VARIANT_S_FTR_ENABLE_SET_FILE_GROUP_OSAL_BY_ID
#define SET_FILE_GROUP_OSAL(fileObj) fileObj.setGroupByID(7000)
#else
#define SET_FILE_GROUP_OSAL(fileObj) fileObj.setGroupByName("eco_osal")
#endif
using namespace dia;
//-----------------------------------------------------------------------------

dia_SrvHandler_CustomerAndBuildSWVersion_Write::dia_SrvHandler_CustomerAndBuildSWVersion_Write ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name,sid,did)
{
   dia_tclFnctTrace trc("dia_SrvHandler_CustomerAndBuildSWVersion_Write::dia_SrvHandler_CustomerAndBuildSWVersion_Write(tCString,tU8,tU16)");
}

//-----------------------------------------------------------------------------

dia_SrvHandler_CustomerAndBuildSWVersion_Write::~dia_SrvHandler_CustomerAndBuildSWVersion_Write ( tVoid )
{
   /*_BP_TRY_BEGIN
   {
      DIA_TR_INF("dia_SrvHandler_CustomerAndBuildSWVersion_Write::~dia_SrvHandler_CustomerAndBuildSWVersion_Write");
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandler_CustomerAndBuildSWVersion_Write::~dia_SrvHandler_CustomerAndBuildSWVersion_Write !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END*/
}

//-----------------------------------------------------------------------------


tVoid
dia_SrvHandler_CustomerAndBuildSWVersion_Write::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandler_CustomerAndBuildSWVersion_Write::vOnProcessRequest");
    // Offset from oDiagMsgBuffer-start to 1st data-byte (e.g. MemorySize-Byte)
   const tU16 MSG_DATA_OFFSET = 4;
   tDiaResult retCode = DIA_FAILED;
   tBool isVersionLabelMatching = TRUE;

   if ( (2 != vecArgs.size()) )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandler_CustomerAndBuildSWVersion_Write: FAILED (Property Not Available) !!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      return;
   }

   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();
   tU8 u8propData[DIA_PROP_LENGTH_MAX] = {0};

   // initialize the data memory
   (void) ::memset(u8propData,0,DIA_PROP_LENGTH_MAX);

   // copy until end of message
   size_t length = oDiagMsgBuffer().u16GetDataLength() - MSG_DATA_OFFSET;
   DIA_TR_INF("Length of Customer & Build SW to be Written = %zu", length);
   tU16 u16EleCount = 0;
   for ( ; u16EleCount < length ; u16EleCount++)
   {
      if ( u16EleCount < DIA_PROP_LENGTH_MAX )
      {
         u8propData[u16EleCount] = pU8[u16EleCount+MSG_DATA_OFFSET];
         DIA_TR_INF("dia_SrvHandler_CustomerAndBuildSWVersion_Write----u8propData[%d] 0x%02x", u16EleCount, u8propData[u16EleCount]);
      }
   }

   /*
   * Read the actual customer version string and build version label stored under
   * registry key [HKEY_LOCAL_MACHINE\SOFTWARE\BLAUPUNKT\VERSIONS\BUILDVERSION_CUSTVERSTRING]
   * and [HKEY_LOCAL_MACHINE\SOFTWARE\BLAUPUNKT\VERSIONS\BUILDVERSION_LABEL] respectively
   */

   tU32 propID_ecu_sw_version      = VoidCast<tU32>(vecArgs[0]);
   tU32 propID_cm_sw_build_version = VoidCast<tU32>(vecArgs[1]);

   std::vector<tU8> ecu_sw_version_number;

   // retrieve size of property
   auto length_ecu_sw_version_number = dia_getPropertySize(propID_ecu_sw_version); //DIA_PROP_LENGTH_MAX;
   ecu_sw_version_number.reserve(length_ecu_sw_version_number);
   ecu_sw_version_number.resize(length_ecu_sw_version_number);

   std::vector<tU8> cm_sw_build_version_number;

   // retrieve size of property
   auto length_cm_sw_build_version_number = dia_getPropertySize(propID_cm_sw_build_version); //DIA_PROP_LENGTH_MAX;
   cm_sw_build_version_number.reserve(length_cm_sw_build_version_number);
   cm_sw_build_version_number.resize(length_cm_sw_build_version_number);

    if( ((dia_getProperty(propID_ecu_sw_version     , ecu_sw_version_number     )) == DIA_SUCCESS) &&
       ((dia_getProperty(propID_cm_sw_build_version, cm_sw_build_version_number))  == DIA_SUCCESS) )
   {
      DIA_TR_INF("LENGTH OF ACTUAL CUSTOMER VERSION STRING = %zu", ecu_sw_version_number.size() /*length_ecu_sw_version_number */);
      DIA_TR_INF("LENGTH OF ACTUAL BUILD VERSION LABEL = %zu", cm_sw_build_version_number.size() /*length_cm_sw_build_version_number */);

      //concatenate the build version label to customer version string
      std::vector<tU8> concatenated_version;
      concatenated_version.clear();

      tU16 u16Count = 0;
      for( ; u16Count < ecu_sw_version_number.size() - 1; u16Count++)
      {
         concatenated_version.push_back(ecu_sw_version_number[u16Count]);
      }
      concatenated_version.push_back('_');
      for(u16Count = 0 ; u16Count < cm_sw_build_version_number.size() - 1; u16Count++)
      {
         concatenated_version.push_back(cm_sw_build_version_number[u16Count]);
      }

      // compare the actual customer version string and build version label (u8buffer) with the same received through input(u8propData)
      size_t ubuffCount = concatenated_version.size();
      size_t upropCount = length;

      for ( ; ubuffCount > 0 ; --ubuffCount)
      {
         if(concatenated_version[ubuffCount - 1] != u8propData[upropCount - 1])
         {
            isVersionLabelMatching = FALSE;
            DIA_TR_INF("ACTUAL DATABYTE: 0x%02x and SERVICE PARAMETER DATABYTE: 0x%02x",concatenated_version[ubuffCount-1], u8propData[upropCount-1]);
            break;
         }
         DIA_TR_INF("ACTUAL DATABYTE: 0x%02x and SERVICE PARAMETER DATABYTE: 0x%02x",concatenated_version[ubuffCount-1], u8propData[upropCount-1]);
         upropCount--;
      }

      //If both the version labels are matching then create /var/opt/bosch/persistent/registry/customerversion_reg.cfg and copy the entire service parameter into it
      if(isVersionLabelMatching == TRUE)
      {
         DIA_TR_INF("ACTUAL BUILD VERSION LABEL/CUSTOMER SW VERSION IS MATCHING WITH SERVICE PARAMETER");

         dia_FileDir diagDir(DIR_NAME);
         DIA_TR_INF("Creating Directory \"%s\"",DIR_NAME);
         if ( diagDir.create() != DIA_SUCCESS )
         {
            DIA_TR_ERR("##### Creation of Directory \"%s\" Failed !! #####",DIR_NAME);
         }
         else
         {
            DIA_TR_INF("Creating File \"%s\"",FILE_NAME);
            dia_File cfgFile(FILE_NAME);
            if (DIA_SUCCESS==cfgFile.open("w"))
            {
               DIA_TR_INF("Writing Service Parameter in File \"%s\"",FILE_NAME);

               size_t propLength = length;

               if ( ( cfgFile.rawWrite(u8propData, &propLength) ) != DIA_SUCCESS )
               {
                  DIA_TR_ERR("##### FAILED TO WRITE SERVICE PARAMETERS IN CFG FILE !!! #####");
               }
               else
               {
                  retCode = DIA_SUCCESS;
                  DIA_TR_INF("dia_SrvHandler_CustomerAndBuildSWVersion_Write::vOnProcessRequest rawWrite success");
               }
            }
            else
            {
               DIA_TR_ERR("OPENING OF FILE \"%s\" FAILED !! #####", FILE_NAME);
            }

            if (DIA_SUCCESS!=cfgFile.close())
            {
               retCode = DIA_FAILED;
               DIA_TR_ERR("### ERROR. CLOSE() failed for %s ####", FILE_NAME);
            }

            SET_FILE_GROUP_OSAL(cfgFile);
            if (DIA_SUCCESS!=cfgFile.changeMode(DIA_C_FILE_MODE_USER_RW|DIA_C_FILE_MODE_GROUP_RW))
            {
               retCode = DIA_FAILED;
               DIA_TR_ERR("### ERROR. changeMode() failed for %s ####", FILE_NAME);
            }

            DIA_TR_INF("Perform double sync for file system");
            sync();
            OSAL_s32ThreadWait(100);
            sync();
            OSAL_s32ThreadWait(100);
         }
      }
      else
      {
         DIA_TR_INF("ACTUAL AND SERVICE PARAMETER BUILD VERSION LABEL/CUSTOMER SW VERSION NOT MATCHING ");
      }
   }
   else
   {
      DIA_TR_INF("NO BUILD VERSION LABEL/CUSTOMER SW VERSION PRESENT UNDER REGISTRY ");
   }

   if ( retCode == DIA_SUCCESS )
   {
      // Sending back the positive answer
      DIA_TR_INF("dia_SrvHandler_CustomerAndBuildSWVersion_Write::vOnProcessRequest SUCCESSFUL");
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START);
      vResReadyAndQuit();
   }
   else
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandler_CustomerAndBuildSWVersion_Write::vOnProcessRequest FAIL");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
