/*!
 * \file       dia_RtCtrlReadSystemOperationTimeForSwVer.cpp
 *
 * \brief      Class for UDS service LCM_ReadSystemOperationTimeForSWVersion
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 */

#include "common/services/uds/production/dia_RtCtrlReadSystemOperationTimeForSwVer.h"

namespace dia {

// convert received uds-request
bool dia_ReadSystemOperationTimeForSWVersion::parseRequest( std::vector<tU8> const &uds, dia_tSpmSVPReqSystemOperationTimeForSWVersion &dia) {
   // todo:check length of uds-input
   dia.mIndex=uds[0];
   return true;
}


// assemble answer
tDiaResult dia_ReadSystemOperationTimeForSWVersion::assembleResult(dia_tSpmSVPSystemOperationTimeForSWVersion  const &dia, std::vector<tU8>& uds) {
   dia_u32ToUds(dia.mTimeInSeconds, uds);
   dia_diaToUds(dia.mVersion, uds);
   return DIA_SUCCESS;
}

}
