/*!
 * \file       dia_RtCtrlReadStartupTimeStatisticForSwVer.cpp
 *
 * \brief      Class for UDS service LCM_ReadStartupTimeStatisticForSWVersion
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 */

#include "common/services/uds/production/dia_RtCtrlReadStartupTimeStatisticForSwVer.h"

namespace dia {

// convert received uds-request
bool dia_ReadStartupTimeStatisticForSWVersion::parseRequest( std::vector<tU8> const &uds, dia_tSpmSVPReqStartupTimeStatisticForSWVersion &dia) {
   DIA_CHECK_UDS_LEN_EQ(1);
   dia.mIndex=uds[0];
   return true;
}


// assemble answer
tDiaResult dia_ReadStartupTimeStatisticForSWVersion::assembleResult(dia_tSpmSVPStartupTimeStatisticForSWVersion  const &dia, std::vector<tU8>& uds) {
   dia_diaToUds(dia.mData, uds);
   dia_diaToUds(dia.mVersion, uds);
   return DIA_SUCCESS;
}

}
