/*!
 * \file       dia_RtCtrlReadResetInformationForSwVer.cpp
 *
 * \brief      Class for UDS service LCM_ReadResetInformationForSWVersion
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 */

#include "common/services/uds/generic/dia_ToUdsHelpers.h"
#include "common/services/uds/production/dia_UdsHelpersSpm.h"
#include "common/services/uds/production/dia_RtCtrlReadResetInformationForSwVer.h"

namespace dia {

// convert received uds-request
bool dia_ReadResetInformationForSWVersion::parseRequest( std::vector<tU8> const& uds, dia_tSpmSVPReqResetInformationForSWVersion &dia) {
   dia.mIndex=uds[0];
   return true;
}




// assemble answer
tDiaResult dia_ReadResetInformationForSWVersion::assembleResult(dia_tSpmSVPResetInformationForSWVersion  const &dia, std::vector<tU8>& uds) {
   dia_diaToUds(dia.mData, uds);
   dia_diaToUds(dia.mVersion, uds);
   return DIA_SUCCESS;
}

}
