/*!
 * \file       dia_RtCtrlReadResetHistoryForSwVer.cpp
 *
 * \brief      Class for UDS service LCM_ReadResetHistoryForSWVersion
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 */

#include "common/services/uds/production/dia_RtCtrlReadResetHistoryForSwVer.h"

namespace dia {

// convert received uds-request
bool dia_ReadResetHistoryForSWVersion::parseRequest( std::vector<tU8> const &uds, dia_tSpmSVPReqResetHistoryForSWVersion &dia) {
   dia.mIndex=uds[0];
   DIA_TR_INF("dia_ReadResetHistoryForSWVersion::parseRequest() mIndex=%u", dia.mIndex);
   printf("dia_ReadResetHistoryForSWVersion:parseRequest() mIndex=%u", dia.mIndex);

   return true;
}




// assemble answer
tDiaResult dia_ReadResetHistoryForSWVersion::assembleResult(dia_tSpmSVPResetHistoryForSWVersion  const &dia, std::vector<tU8>& uds) {
   dia_diaListToUds(dia.mList, uds, 20);
   dia_diaToUds(dia.mVersion, uds);
   return DIA_SUCCESS;
}


}
