/*!
 * \file       dia_RtCtrlReadMaximumRamConsumptionForSwVer.h
 *
 * \brief      Class for UDS service LCM_ReadMaximumRamConsumptionForSWVersion
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_RT_CTRL_READ_MAXIMUM_RAM_CONSUMPTION_FOR_SW_VER__
#define __INCLUDED_DIA_RT_CTRL_READ_MAXIMUM_RAM_CONSUMPTION_FOR_SW_VER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif

#include "common/services/uds/production/dia_UdsHelpersSpm.h"
#include "common/framework/protocols/uds/rtctrl/dia_RoutineSimple.h"
#include "common/interfaces/dia_ISpmSVPListener.h"

namespace dia {


class dia_ReadMaximumRamConsumptionForSWVersion : public dia_RoutineSimple<dia_ISpmSVP,
                                                                           dia_ISpmSVPListenerImpl,
                                                                           dia_tSpmSVPReqMaximumRamConsumptionForSWVersion,
                                                                           dia_tSpmSVPMaximumRamConsumptionForSWVersion>
{
   public:
   dia_ReadMaximumRamConsumptionForSWVersion ():
      dia_RoutineSimple("dia_ReadMaximumRamConsumptionForSWVersion", 
                        DIA_C_U16_DID_RBCM_READ_MAXIMUM_RAM_CONSUMPTION_FOR_SW_VERSION, 
                        DIA_EN_RTCTRL_ID_READ_MAXIMUM_RAM_CONSUMPTION_FOR_SW_VERSION){};
   
   bool parseRequest( std::vector<tU8> const &uds, dia_tSpmSVPReqMaximumRamConsumptionForSWVersion &dia);
   tDiaResult assembleResult(dia_tSpmSVPMaximumRamConsumptionForSWVersion  const &dia, std::vector<tU8>& uds);


};

}
#endif

