/*!
 * \file       dia_RtCtrlReadErrorStateHistoryForSwVer.cpp
 *
 * \brief      Class for UDS service LCM_ReadErrorStateHistoryForSWVersion
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 */

#include "common/services/uds/production/dia_RtCtrlReadErrorStateHistoryForSwVer.h"

namespace dia {


// convert received uds-request
bool dia_ReadErrorStateHistoryForSWVersion::parseRequest( std::vector<tU8> const &uds, dia_tSpmSVPReqErrorStateHistoryForSWVersion &dia) {
   // todo:check length of uds-input
   dia.mIndex=uds[0];
   dia.mErrorStateIndex=uds[1];
   return true;
}


// assemble answer
tDiaResult dia_ReadErrorStateHistoryForSWVersion::assembleResult(dia_tSpmSVPErrorStateHistoryForSWVersion  const &dia, std::vector<tU8>& uds) {
   dia_diaListToUds(dia.mList, uds, 60);
   dia_diaToUds(dia.mVersion, uds);
   return DIA_SUCCESS;
}

}
