/*
 * dia_RoutineCtrlStartSoftwareUpdate.h
 *
 *  Created on: 21.08.2012
 *      Author: gib2hi
 */

#ifndef DIA_ROUTINECTRLSTARTSOFTWAREUPDATE_H_
#define DIA_ROUTINECTRLSTARTSOFTWAREUPDATE_H_

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SWUPDATE_LISTENER__
#include "common/interfaces/dia_ISwUpdateListener.h"
#endif

namespace dia
{

class RoutineCtrlStartSoftwareUpdate
   : public dia_Routine,
     public dia_ISwUpdateListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RoutineCtrlStartSoftwareUpdate);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlStartSoftwareUpdate);

public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_ISwUpdateListenerImpl methods
   //
   //-------------------------------------------------------------------------
   //! routine control status handling function
   virtual void vOnRecoveryMode ( tBool recoveryMode );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_Routine methods
   //
   //-------------------------------------------------------------------------
    //! handle timeout from UDS session object
   virtual void vOnServiceTimeout ( void );

protected:

};

} //namespace dia

#endif /* DIA_ROUTINECTRLSTARTSOFTWAREUPDATE_H_ */
