/*!
 * \file       dia_RoutineCtrlSetSystemToDeliveryState.cpp
 *
 * \brief      tbd
 *
 * \details    tbd
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include <common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h>
#endif

#include "dia_RoutineCtrlSetSystemToDeliveryState.h"

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEMSETTINGS__
#include <common/interfaces/dia_ISystemSettings.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

namespace dia
{

using namespace dia;
//------------------------------------------------------------------------------

RoutineCtrlSetSystemToDeliveryState::RoutineCtrlSetSystemToDeliveryState ( void )
   : dia_Routine("dia_RoutineCtrlSetSystemToDeliveryState", DIA_C_U16_DID_RBCM_RTCTRL_SET_SYSTEM_TO_DELIVERY_STATE, DIA_EN_RTCTRL_ID_RESET_TO_DELIVERY),
     mIsLockRequired(false)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlSetSystemToDeliveryState::dia_RoutineCtrlSetSystemToDeliveryState()");
}

//------------------------------------------------------------------------------

RoutineCtrlSetSystemToDeliveryState::~RoutineCtrlSetSystemToDeliveryState ( void )
{
   DIA_TR_INF(("dia_RoutineCtrlSetSystemToDeliveryState::~dia_RoutineCtrlSetSystemToDeliveryState"));

   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IAuthorizationLevelListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR(("dia_RoutineCtrlSetSystemToDeliveryState::~dia_RoutineCtrlSetSystemToDeliveryState - Exception caught"));
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlSetSystemToDeliveryState::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{

	dia_tclFnctTrace oTrace("dia_RoutineCtrlSetSystemToDeliveryState::start()");



	// prepare processing of the routine

	vInitialize();



	if ( params.size() != 1 ) {
		DIA_TR_INF("INVALID PARAMETERS");
		return DIA_FAILED;
	}



	// check if we need to lock at the end of the system set

	mIsLockRequired = ( params[0] == 0xFF ) ? false : true;

	// check what is the current rouine status before processing
	dia_eRoutineStatus eRoutineStatusBefore = eGetStatus();
	DIA_TR_INF("dia_RoutineCtrlSetSystemToDeliveryStatePSA::start: eRoutineStatusBefore = %d", eRoutineStatusBefore);	



	dia_ISystemSettings* pInterface = 0;

	tDiaResult retCode = queryInterface<dia_ISystemSettings>(&pInterface);

	if ( (retCode == DIA_SUCCESS) && pInterface )

	{

		if ( DIA_SUCCESS == pInterface->processSystemSetting(DIA_C_UID_SYSTEM_SETTING_TYPE_PRODUCTION,*this, tCookieType(this)) )

		{
			dia_eRoutineStatus eRoutineStatusAfter = eGetStatus();
			DIA_TR_INF("dia_RoutineCtrlSetSystemToDeliveryStatePSA::start: eRoutineStatusAfter = %d", eRoutineStatusAfter);
			if(eRoutineStatusBefore == eRoutineStatusAfter) // Fix for bug 237392 in CMD Diag
			{
				DIA_TR_INF("u32StartSystemSet is success!!!");
				eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
				retCode = DIA_SUCCESS;
			}
			else
			{
				DIA_TR_INF("Routine status is modified by SysSet fw in different thread context, so better dont overwrite!!!");
				retCode = DIA_SUCCESS;
			}
		}
		else
		{
			DIA_TR_INF("no flush done!!!");
			mIsResultReady = TRUE;
			eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
		}
	}
	return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlSetSystemToDeliveryState::requestResult ( std::vector<tU8>& results )
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);

   results.push_back(mapStatus2UDSResult());

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

void
RoutineCtrlSetSystemToDeliveryState::vOnServiceTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlSetSystemToDeliveryState::vOnServiceTimeout()");
}

//------------------------------------------------------------------------------

void
RoutineCtrlSetSystemToDeliveryState::onSystemSettingProcessed( dia_UID /*typeID*/, const dia_SystemSettingExtendedData& /*extData*/, tDiaResult resultCode, tCookieType cookie )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlSetSystemToDeliveryState::vSystemSetResult()");

   RoutineCtrlSetSystemToDeliveryState* pCookie = VoidCast<RoutineCtrlSetSystemToDeliveryState*>(cookie);
   if ( pCookie != this ) return;

   bool isComplete = true;

   bool isLockRequired = mIsLockRequired;
   if ( dia_checkPropertyValue(DIA_PROP_CM_CONFIG_INTERFACE_LOCK) == FALSE ) isLockRequired = false;

   if ( (resultCode == DIA_SUCCESS) && (mStatus == DIA_EN_RTCTRL_STATUS_IN_PROGRESS) )
   {
      if ( isLockRequired )
      {
         bool errorDetected = true;

         //Check if the Seed Input Data for the ALD (Mainboard Serial No) is available before sending the Lock Device command!
         std::vector<tU8> initVector;
         initVector.clear();
         if ( (dia_getProperty(DIA_PROP_CM_ALD_SEED_INPUT_DATA,initVector) != DIA_SUCCESS) || (!initVector.size()) )
         {
        	 DIA_TR_ERR("##### dia_RoutineCtrlSetSystemToDeliveryState: DIA_PROP_CM_ALD_SEED_INPUT_DATA NOT AVAILABLE #####");
         }
         else
         {
          dia_IAuthorizationLevel* pAuthLevel = 0;
          if ( (querySysAdapterInterface<dia_IAuthorizationLevel>(&pAuthLevel) == DIA_SUCCESS) && pAuthLevel )
          {
            (void) setSysAdapterListener<dia_IAuthorizationLevelListener>(this);
            if ( pAuthLevel->lockDevice() == DIA_SUCCESS )
            {
               DIA_TR_ERR("dia_RoutineCtrlSetSystemToDeliveryState: requested lockDevice successfully.");
               errorDetected = false;
               isComplete    = false;
            }
          }
         else
         {
            DIA_TR_ERR("dia_RoutineCtrlSetSystemToDeliveryState: querySysAdapterInterface FAILED !");
         }
        }

         if ( errorDetected )
         {
            DIA_TR_ERR("dia_RoutineCtrlSetSystemToDeliveryState::onSystemSettingProcessed (COMPLETED_AND_NOK) -- FAILED TO LOCK DEVICE !!!");
            eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
         }
      }

      else
      {
         DIA_TR_INF("dia_RoutineCtrlSetSystemToDeliveryState::onSystemSettingProcessed (COMPLETED_OK)"); // currently we only have a dummy implementation
         eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
      }
   }
   else
   {
      DIA_TR_INF("dia_RoutineCtrlSetSystemToDeliveryState::onSystemSettingProcessed (COMPLETED_AND_NOK)");
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   }

   if ( isComplete )
   {
      mIsResultReady = TRUE;
      dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
   }
}

//-----------------------------------------------------------------------------

void
RoutineCtrlSetSystemToDeliveryState::vOnLockDeviceResult ( tDiaResult retCode )
{
   (void) unsetSysAdapterListener<dia_IAuthorizationLevelListener>(this);

   if ( retCode == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_RoutineCtrlSetSystemToDeliveryState::vOnLockDeviceResult (COMPLETED_AND_OK");
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   }
   else
   {
      DIA_TR_ERR("dia_RoutineCtrlSetSystemToDeliveryState::vOnLockDeviceResult (COMPLETED_AND_NOK) -- FAILED TO LOCK DEVICE !!!");
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   }

   mIsResultReady = TRUE;
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}

} //namespace dia
