/*!
 * \file       dia_RoutineCtrlSetDiagnosticsToDeliveryState.cpp
 *
 * \brief      tbd
 *
 * \details    trigger plugin that resets diagnostics internal data
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2017 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include <common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h>
#endif

#include "dia_RoutineCtrlSetDiagnosticsToDeliveryState.h"

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEMSETTINGS__
#include <common/interfaces/dia_ISystemSettings.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_HASH_CALCULATOR__
#include <common/framework/utils/dia_HashCalculator.h>
#endif

namespace dia
{

using namespace dia;
//------------------------------------------------------------------------------

RoutineCtrlSetDiagnosticsToDeliveryState::RoutineCtrlSetDiagnosticsToDeliveryState ( void )
   : dia_Routine("dia_RoutineCtrlSetDiagnosticsToDeliveryState", DIA_C_U16_DID_RBCM_RTCTRL_SET_DIAGNOSTICS_TO_DELIVERY_STATE)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlSetDiagnosticsToDeliveryState::dia_RoutineCtrlSetDiagnosticsToDeliveryState()");
}

//------------------------------------------------------------------------------

RoutineCtrlSetDiagnosticsToDeliveryState::~RoutineCtrlSetDiagnosticsToDeliveryState ( void )
{
   DIA_TR_INF(("dia_RoutineCtrlSetDiagnosticsToDeliveryState::~dia_RoutineCtrlSetDiagnosticsToDeliveryState"));
}

//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlSetDiagnosticsToDeliveryState::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlSetDiagnosticsToDeliveryState::start()");

   tDiaResult retCode = DIA_FAILED;

   // prepare processing of the routine
   vInitialize();

   if ( params.size() != 1 ) {
      DIA_TR_INF("INVALID PARAMETERS");
      return retCode;
   }

   // TODO:  Ignore the sub-parameter checking currently, enable the checking in future if needed
   char const *sysSettingType=DIA_C_STR_SYSTEM_SETTING_TYPE_DIAGNOSTICS_INTERNAL;
   if (params[0] == 1) {
      sysSettingType=DIA_C_STR_SYSTEM_SETTING_TYPE_TEST;
   }

   // routine starts
   dia_ISystemSettings* pInterface = 0;
   retCode = queryInterface<dia_ISystemSettings>(&pInterface);
   if ( (retCode == DIA_SUCCESS) && pInterface )
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
      if ( DIA_SUCCESS == pInterface->processSystemSetting(dia_getHashCodeFromString(sysSettingType),*this, (tCookieType)this) )
      {
         DIA_TR_INF("processSystemSetting [0x%08x] is success!!!",dia_getHashCodeFromString(sysSettingType));

         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_INF("processSystemSetting [0x%08x] is failed!!!",dia_getHashCodeFromString(sysSettingType));
         mIsResultReady = TRUE;
         eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
      }
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlSetDiagnosticsToDeliveryState::requestResult ( std::vector<tU8>& results )
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);

   results.push_back(mapStatus2UDSResult());

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

void
RoutineCtrlSetDiagnosticsToDeliveryState::vOnServiceTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlSetDiagnosticsToDeliveryState::vOnServiceTimeout()");
}

//------------------------------------------------------------------------------

void
RoutineCtrlSetDiagnosticsToDeliveryState::onSystemSettingProcessed( dia_UID /*typeID*/, const dia_SystemSettingExtendedData& /*extData*/, tDiaResult resultCode, tCookieType cookie )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlSetDiagnosticsToDeliveryState::onSystemSettingProcessed()");

   RoutineCtrlSetDiagnosticsToDeliveryState* pCookie = UnsafeVoidCast<RoutineCtrlSetDiagnosticsToDeliveryState>(cookie);
   if ( pCookie != this) return;

   if ( (resultCode == DIA_SUCCESS) && (mStatus == DIA_EN_RTCTRL_STATUS_IN_PROGRESS) )
   {
      DIA_TR_INF("dia_RoutineCtrlSetDiagnosticsToDeliveryState::onSystemSettingProcessed (COMPLETED_OK)"); // currently we only have a dummy implementation
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   }
   else
   {
      DIA_TR_INF("dia_RoutineCtrlSetDiagnosticsToDeliveryState::onSystemSettingProcessed (COMPLETED_AND_NOK)");
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   }

   mIsResultReady = TRUE;
   //Don't inform the dia_RoutineCtrlManager about a vOnRoutineUpdate, since the start was synchronous

}

} //namespace dia
