/************************************************************************
* FILE:         dia_RoutineCtrlRunInClearResults.h
* PROJECT:      GM NexGen
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Classes for UDS service StressTest
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 10.11.14  | TMS Plischke            | initial version
*
*************************************************************************/

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_RUNIN_CLEAR_RESULTS__
#define __INCLUDED_DIA_ROUTINE_CTRL_RUNIN_CLEAR_RESULTS__

//#ifndef __INCLUDED_DIA_EXTERN_STDC_FILE_TREE_WALK__
//#define __INCLUDED_DIA_EXTERN_STDC_FILE_TREE_WALK__
#ifndef _FTW_H
#include <ftw.h>
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia
{

class RoutineCtrlRunInClearResults
   : public dia_Routine
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RoutineCtrlRunInClearResults);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlRunInClearResults);

public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   virtual tDiaResult requestResult ( std::vector<tU8>& /*results*/ );

protected:
   static int remove_runin_files ( const char *fpath, const struct stat *sb, int tflag, struct FTW *ftwbuf );
};

} //namespace dia

#endif /* __INCLUDED_DIA_ROUTINE_CTRL_RUNIN_CLEAR_RESULTS__ */

