/************************************************************************
* FILE:         dia_RoutineCtrlRunInClearResults.cpp
* PROJECT:      GM NexGen
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Classes for UDS service StressTest
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 10.11.14  | BSOT Plischke           | initial version
*
*************************************************************************/

#ifdef _XOPEN_SOURCE
#undef _XOPEN_SOURCE
#endif

#define _XOPEN_SOURCE 500
#include <stdio.h>
#include <ftw.h>
#include <unistd.h>

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include "common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h"
#endif

//#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
//#include <common/framework/config/dia_ConfigManager.h>
//#endif

#include "dia_RoutineCtrlRunInClearResults.h"

//#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_PROD
//#include "trcGenProj/Header/dia_RoutineCtrlRunInClearResults.cpp.trc.h"
//#endif

/*#define ROUTINE_OK         0
#define ROUTINE_NOK        1
#define ROUTINE_RUNNING    3
#define ROUTINE_STOPPED    4*/

namespace dia
{

static tCString strDiagRunInDir = "/var/opt/bosch/dynamic/diagnosis/runin";

//-----------------------------------------------------------------------------

RoutineCtrlRunInClearResults::RoutineCtrlRunInClearResults()
   : dia_Routine("dia_RoutineCtrlRunInClearResults", DIA_C_U16_DID_DIAGNOSIS_RUN_IN_CLEAR_RESULTS, DIA_EN_RTCTRL_ID_DIAG_RUN_IN_CLEAR_RESULTS, DIA_EN_RTCTRL_TYPE_SHORT_TERM)
{
    dia_tclFnctTrace oTrace("dia_RoutineCtrlRunInClearResults::dia_RoutineCtrlRunInClearResults");
}

//------------------------------------------------------------------------------

RoutineCtrlRunInClearResults::~RoutineCtrlRunInClearResults()
{}

//------------------------------------------------------------------------------

int
RoutineCtrlRunInClearResults::remove_runin_files ( const char* fpath, const struct stat* /*sb*/, int /*tflag*/, struct FTW* /*ftwbuf*/ )
{
   DIA_TR_INF("Removing %s",fpath);

   int retCode = remove(fpath);

   if ( retCode != 0 )
   {
      DIA_TR_ERR("##### FAILED TO REMOVE \"%s\"",fpath);
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
RoutineCtrlRunInClearResults::start ( std::vector<tU8>& /*params*/, tU8 /*timerValue*/ )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlRunInClearResults::start");

   if ( ::nftw(strDiagRunInDir, RoutineCtrlRunInClearResults::remove_runin_files, 64, FTW_DEPTH|FTW_PHYS) != 0 )
   {
      DIA_TR_ERR("##### REMOVAL OF RUNIN FILES FAILED #####");
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   }
   else
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
      // pla2hi: we need to sync here
      /* Two syncs are necessary to make sure that a filesystem flush to flash is really finished */
      system("sync");
      system("sync");
   }

   DIA_TR_INF("dia_RoutineCtrlRunInClearResults::start => Status:%x", mStatus);

   mIsResultReady = TRUE;

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlRunInClearResults::requestResult ( std::vector<tU8>& results )
{
   dia::ScopeTrace oTrace(__PRETTY_FUNCTION__);

   results.push_back(mapStatus2UDSResult());

   return DIA_SUCCESS;
}

} //namespace dia
