/************************************************************************
* FILE:         dia_RoutineCtrRunIn.h
* PROJECT:      GM NexGen
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Classes for UDS service StressTest
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 10.11.14  | TMS Plischke            | initial version
*
*************************************************************************/

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_RUNIN__
#define __INCLUDED_DIA_ROUTINE_CTRL_RUNIN__

namespace dia
{

typedef struct
{
   const char* const  fileName;
   tU8            sizePosResponse;
   tU8            dataPosResponse[5];
   tU16           startPosDataToGet;
}trFileInfo;

typedef struct
{
   tU32 pos;
   tU32 size;
   trFileInfo sDataInfo;
}trRunInCommandList;



class RoutineCtrlRunIn : public dia_Routine
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RoutineCtrlRunIn);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlRunIn);

   public:

   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   virtual tDiaResult stop ( std::vector<tU8>& params); //lint !e1735 Info: verified that same default parameter is used as in base class
   virtual tDiaResult requestResult ( void );
   //! this method is used to retrieve the result data
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   private:
   tDiaResult getActivationFlag (tU8& statusFlag) const;
   tDiaResult writeRunResult (tU16 run, std::vector<tU8>& data ) const;
   tDiaResult checkFile (tU16 run, const trFileInfo* const pFileCheckData, std::vector<tU8>& response ) const;
   tDiaResult readFileToBuffer (const char* const fileName, char Buffer[], size_t& size) const;

   //tDiaResult getResponseFromBuffer (char Buffer[], int maxSize, char responseBuffer[], int maxSizeResponse);
   //tDiaResult getRequestFromBuffer (char Buffer[], int maxSize, char requestBuffer[], int maxSizeRequest);
   tDiaResult compareResponse (const tU8 compareBuffer[], std::vector<tU8>& response,  tU8 size) const;
   tDiaResult getRequestFromBuffer (const char Buffer[], size_t bufferSize, std::vector<tU8>& requestBuffer) const;
   tDiaResult getResponseFromBuffer (const char Buffer[], size_t bufferSize, std::vector<tU8>& responseBuffer) const;

   tDiaResult writeDatoToResponseBuffer (tU16 run, const trRunInCommandList* const pList, std::vector<tU8>& data ) const;
};

} //namespace dia

#endif /* __INCLUDED_DIA_ROUTINE_CTRL_RUNIN__ */
