/*
 * dia_RoutineCtrllcmstartalternativesoftware.h
 *
 *  Created on: 18.01.2014
 *      Author: nbs3kor
 */

#ifndef DIA_ROUTINECTRLLCMSTARTALTERNATIVESOFTWARE_H_
#define DIA_ROUTINECTRLLCMSTARTALTERNATIVESOFTWARE_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_LONGTERM__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineLong.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

class dia_RoutineCtrlLcmStartAlternativeSoftware
   : public dia_RoutineLong,
     public dia_ISpmListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlLcmStartAlternativeSoftware);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlLcmStartAlternativeSoftware);

public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class

   //! return DIA_SUCCESS or DIA_E_SEQUENCE_ERROR in case of failure
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   //! Callback for SystemAdapter
   virtual void vOnGetSystemRestartValue ( dia_eSpmRestartMode mode );

protected:

   dia_eSpmRestartMode mSystemRestartMode;
};

#endif /* DIA_ROUTINECTRLLCMSTARTALTERNATIVESOFTWARE_H_ */
