/************************************************************************
* FILE:         dia_RoutineCtrlIPODSelfTest.h
* PROJECT:      GM NexGen
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Classes for UDS service Apple Selftest
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 04.08.10  | TMS Plischke            | initial version
* 13.02.14  | shw2abt                 | Merge to VM MIBE
*
*************************************************************************/

#ifndef DIA_ROUTINECTRLIPODSELFTEST_H
#define DIA_ROUTINECTRLIPODSELFTEST_H

#ifndef __INCLUDED_DIA_INTERFACE_MEDIAIPOD_LISTENER__
#include <common/interfaces/dia_IMediaIPODListener.h>
#endif


namespace dia
{

class RoutineCtrlIPODSelfTest : public dia_Routine,
                                    public dia_IMediaIPODListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RoutineCtrlIPODSelfTest);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlIPODSelfTest);

   public:

   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   //! handle timeout from UDS session object
   virtual tVoid vOnServiceTimeout ( tVoid );

   virtual void vOnSelfTestDone ( tDiaResult );
};

} //namespace dia

#endif /* DIA_ROUTINECTRLIPODSELFTEST_H */
