/************************************************************************
* FILE:         dia_RoutineCtrlIPODSelfTest.cpp
* PROJECT:      GM NexGen
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Classes for UDS service Apple Selftest
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 04.08.10  | TMS Plischke            | initial version
*
*************************************************************************/

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include <common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h>
#endif

#include "dia_RoutineCtrlIPODSelfTest.h"

namespace dia
{

RoutineCtrlIPODSelfTest::RoutineCtrlIPODSelfTest()
      : dia_Routine("dia_RoutineCtrlIPODSelfTest", DIA_C_U16_DID_RBCM_IPOD_SELFTEST, DIA_EN_RTCTRL_ID_IPOD_SELFTEST, DIA_EN_RTCTRL_TYPE_SHORT_TERM)
{
    dia_tclFnctTrace oTrace("dia_RoutineCtrlIPODSelfTest::dia_RoutineCtrlIPODSelfTest");
}

//------------------------------------------------------------------------------

RoutineCtrlIPODSelfTest::~RoutineCtrlIPODSelfTest()
{
//    dia_tclFnctTrace oTrace("dia_RoutineCtrlIPODSelfTest::~dia_RoutineCtrlIPODSelfTest");

    _BP_TRY_BEGIN
    {
        (void) unsetSysAdapterListener<dia_IMediaIPODListener>(this);
    }
    _BP_CATCH_ALL
    {
       DIA_TR_ERR("dia_RoutineCtrlIPODSelfTest::~dia_RoutineCtrlIPODSelfTest - Exception caught!");
       DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlIPODSelfTest::start ( std::vector<tU8>& /*params*/, tU8 /*timerValue*/ )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlIPODSelfTest::start");

   tDiaResult retCode = DIA_FAILED;

   // prepare processing of the routine
   vInitialize();

   dia_IMediaIPOD* pIPOD = NULL;

   if ( (querySysAdapterInterface<dia_IMediaIPOD>(&pIPOD) == DIA_SUCCESS) && pIPOD )
   {
      (void) setSysAdapterListener<dia_IMediaIPODListener>(this);

      if ( pIPOD->vSelfTest() != DIA_SUCCESS)
      {
         DIA_TR_ERR("dia_RoutineCtrlIPODSelfTest::start => ERROR: vSelfTest != DIA_SUCCESS");
      }// if ( pIPOD->vSelfTest() != DIA_SUCCESS)
      else
      {
         DIA_TR_ERR("dia_RoutineCtrlIPODSelfTest::start => Send Successfully to Server");
         eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
         retCode = DIA_SUCCESS;
      }
   }// if ( pIPOD != NULL)
   else
   {
      DIA_TR_ERR("dia_RoutineCtrlIPODSelfTest::start => ERROR: pIPOD == NULL");
   }

   if ( retCode != DIA_SUCCESS )
   {
      (void) unsetSysAdapterListener<dia_IMediaIPODListener>(this);
   }

   return retCode;
}

//----------------------------------------------------------------------------------------

void
RoutineCtrlIPODSelfTest::vOnSelfTestDone ( tDiaResult result)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlIPODSelfTest::vOnSelfTestDone");

   DIA_TR_INF("dia_RoutineCtrlIPODSelfTest::vOnSelfTestDone => Result = %d", result);

   (void) unsetSysAdapterListener<dia_IMediaIPODListener>(this);

   if (result == DIA_SUCCESS)
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   }
   else
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   }

   mIsResultReady = TRUE;
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}

//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlIPODSelfTest::requestResult ( std::vector<tU8>& results )
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);

   results.push_back(mapStatus2UDSResult());
   results.insert(results.end(), mResults.begin(), mResults.end());

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tVoid
RoutineCtrlIPODSelfTest::vOnServiceTimeout ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlIPODSelfTest::vOnServiceTimeout");

   DIA_TR_ERR("dia_RoutineCtrlIPODSelfTest::vOnServiceTimeout");

   (tVoid) unsetSysAdapterListener<dia_IMediaIPODListener>(this);
}

} //namespace dia
