/*
 * dia_RoutineCtrlGNSSCalcAndVerifyChecksum.h
 *
 *  Created on: 31.07.2014
 *      Author: bhs1hi
 */
 // TTFis: DIA_REQ UDS 04 31 01 30 69

#ifndef __INCLUDED_DIA_RTCTRL_GNSS_CALC_VERIFY_CHECKSUM_H_
#define __INCLUDED_DIA_RTCTRL_GNSS_CALC_VERIFY_CHECKSUM_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_GNSS_LISTENER__
#include "common/interfaces/dia_IGNSSListener.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_LONGTERM__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineLong.h"
#endif

namespace dia
{

class RoutineCtrlGNSSCalcAndVerifyChecksum : public dia_Routine,
                                             public dia_IGNSSListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RoutineCtrlGNSSCalcAndVerifyChecksum);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlGNSSCalcAndVerifyChecksum);

public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );
   //! handle timeout from UDS session object
   virtual void vOnServiceTimeout ( void );

   //! result of the GNSS firmware checksum
   virtual void vOnGNSSRecFrimwareCrc ( const tU32 firmwareCrc );
};

} //namespace dia

#endif /* __INCLUDED_DIA_RTCTRL_GNSS_CALC_VERIFY_CHECKSUM_H_ */
